/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.handler;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.disruptor.event.DisruptorEvent;
import com.taotao.cloud.disruptor.handler.AbstractAdviceEventHandler;
import com.taotao.cloud.disruptor.handler.DisruptorHandler;
import com.taotao.cloud.disruptor.handler.PathProcessor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public abstract class AbstractPathMatchEventHandler<T extends DisruptorEvent>
extends AbstractAdviceEventHandler<T>
implements PathProcessor<T> {
    protected PathMatcher pathMatcher = new AntPathMatcher();
    protected List<String> appliedPaths = new ArrayList<String>();

    @Override
    public DisruptorHandler<T> processPath(String path) {
        this.appliedPaths.add(path);
        return this;
    }

    protected String getPathWithinEvent(T event) {
        return ((DisruptorEvent)event).getRouteExpression();
    }

    protected boolean pathsMatch(String path, T event) {
        String eventExp = this.getPathWithinEvent(event);
        LogUtils.info((String)"Attempting to match pattern '{}' with current Event Expression '{}'...", (Object[])new Object[]{path, eventExp});
        return this.pathsMatch(path, eventExp);
    }

    protected boolean pathsMatch(String pattern, String path) {
        return this.pathMatcher.match(pattern, path);
    }

    @Override
    protected boolean preHandle(T event) throws Exception {
        if (this.appliedPaths == null || this.appliedPaths.isEmpty()) {
            LogUtils.info((String)"appliedPaths property is null or empty.  This Handler will passthrough immediately.", (Object[])new Object[0]);
            return true;
        }
        for (String path : this.appliedPaths) {
            if (!this.pathsMatch(path, event)) continue;
            LogUtils.info((String)"Current Event Expression matches pattern '{}'.  Determining handler chain execution...", (Object[])new Object[]{path});
            return this.isHandlerChainContinued(event, path);
        }
        return true;
    }

    private boolean isHandlerChainContinued(T event, String path) throws Exception {
        if (this.isEnabled(event, path)) {
            LogUtils.info((String)"Handler '{}' is enabled for the current event under path '{}'.  Delegating to subclass implementation for 'onPreHandle' check.", (Object[])new Object[]{this.getName(), path});
            return this.onPreHandle(event);
        }
        LogUtils.info((String)"Handler '{}' is disabled for the current event under path '{}'.  The next element in the HandlerChain will be called immediately.", (Object[])new Object[]{this.getName(), path});
        return true;
    }

    protected boolean onPreHandle(T event) throws Exception {
        return true;
    }

    protected boolean isEnabled(T event, String path) throws Exception {
        return this.isEnabled(event);
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public List<String> getAppliedPaths() {
        return this.appliedPaths;
    }
}

