/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.handler;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.disruptor.event.DisruptorEvent;
import com.taotao.cloud.disruptor.exception.EventHandleException;
import com.taotao.cloud.disruptor.handler.AbstractEnabledEventHandler;
import com.taotao.cloud.disruptor.handler.HandlerChain;
import com.taotao.cloud.disruptor.handler.HandlerChainResolver;
import java.io.IOException;

public class AbstractRouteableEventHandler<T extends DisruptorEvent>
extends AbstractEnabledEventHandler<T> {
    protected HandlerChainResolver<T> handlerChainResolver;

    public AbstractRouteableEventHandler() {
    }

    public AbstractRouteableEventHandler(HandlerChainResolver<T> handlerChainResolver) {
        this.handlerChainResolver = handlerChainResolver;
    }

    @Override
    protected void doHandlerInternal(T event, HandlerChain<T> handlerChain) throws Exception {
        Throwable t = null;
        try {
            this.executeChain(event, handlerChain);
        }
        catch (Throwable throwable) {
            t = throwable;
        }
        if (t != null) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            String msg = "Handlered event failed.";
            throw new EventHandleException(msg, t);
        }
    }

    protected HandlerChain<T> getExecutionChain(T event, HandlerChain<T> origChain) {
        HandlerChain<T> chain = origChain;
        HandlerChainResolver<T> resolver = this.getHandlerChainResolver();
        if (resolver == null) {
            LogUtils.debug((String)"No HandlerChainResolver configured.  Returning original HandlerChain.", (Object[])new Object[0]);
            return origChain;
        }
        HandlerChain<T> resolved = resolver.getChain(event, origChain);
        if (resolved != null) {
            LogUtils.info((String)"Resolved a configured HandlerChain for the current event.", (Object[])new Object[0]);
            chain = resolved;
        } else {
            LogUtils.info((String)"No HandlerChain configured for the current event.  Using the default.", (Object[])new Object[0]);
        }
        return chain;
    }

    protected void executeChain(T event, HandlerChain<T> origChain) throws Exception {
        HandlerChain<T> chain = this.getExecutionChain(event, origChain);
        chain.doHandler(event);
    }

    public HandlerChainResolver<T> getHandlerChainResolver() {
        return this.handlerChainResolver;
    }

    public void setHandlerChainResolver(HandlerChainResolver<T> handlerChainResolver) {
        this.handlerChainResolver = handlerChainResolver;
    }
}

