/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.handler;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.disruptor.event.DisruptorEvent;
import com.taotao.cloud.disruptor.handler.DefaultNamedHandlerList;
import com.taotao.cloud.disruptor.handler.DisruptorHandler;
import com.taotao.cloud.disruptor.handler.HandlerChain;
import com.taotao.cloud.disruptor.handler.HandlerChainManager;
import com.taotao.cloud.disruptor.handler.Nameable;
import com.taotao.cloud.disruptor.handler.NamedHandlerList;
import com.taotao.cloud.disruptor.util.StringUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class DefaultHandlerChainManager
implements HandlerChainManager<DisruptorEvent> {
    private Map<String, DisruptorHandler<DisruptorEvent>> handlers = new LinkedHashMap<String, DisruptorHandler<DisruptorEvent>>();
    private Map<String, NamedHandlerList<DisruptorEvent>> handlerChains = new LinkedHashMap<String, NamedHandlerList<DisruptorEvent>>();
    private static final String DEFAULT_CHAIN_DEFINATION_DELIMITER_CHAR = ",";

    @Override
    public Map<String, DisruptorHandler<DisruptorEvent>> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Map<String, DisruptorHandler<DisruptorEvent>> handlers) {
        this.handlers = handlers;
    }

    public Map<String, NamedHandlerList<DisruptorEvent>> getHandlerChains() {
        return this.handlerChains;
    }

    public void setHandlerChains(Map<String, NamedHandlerList<DisruptorEvent>> handlerChains) {
        this.handlerChains = handlerChains;
    }

    public DisruptorHandler<DisruptorEvent> getHandler(String name) {
        return this.handlers.get(name);
    }

    @Override
    public void addHandler(String name, DisruptorHandler<DisruptorEvent> handler) {
        this.addHandler(name, handler, true);
    }

    protected void addHandler(String name, DisruptorHandler<DisruptorEvent> handler, boolean overwrite) {
        DisruptorHandler<DisruptorEvent> existing = this.getHandler(name);
        if (existing == null || overwrite) {
            if (handler instanceof Nameable) {
                ((Nameable)((Object)handler)).setName(name);
            }
            this.handlers.put(name, handler);
        }
    }

    @Override
    public void createChain(String chainName, String chainDefinition) {
        String[] handlerTokens;
        if (StringUtils.isBlank((CharSequence)chainName)) {
            throw new NullPointerException("chainName cannot be null or empty.");
        }
        if (StringUtils.isBlank((CharSequence)chainDefinition)) {
            throw new NullPointerException("chainDefinition cannot be null or empty.");
        }
        LogUtils.debug((String)("Creating chain [" + chainName + "] from String definition [" + chainDefinition + "]"), (Object[])new Object[0]);
        for (String token : handlerTokens = this.splitChainDefinition(chainDefinition)) {
            this.addToChain(chainName, token);
        }
    }

    protected String[] splitChainDefinition(String chainDefinition) {
        String trimToNull = StringUtils.trimToNull((String)chainDefinition);
        if (trimToNull == null) {
            return null;
        }
        String[] split = StringUtils.splits(trimToNull, DEFAULT_CHAIN_DEFINATION_DELIMITER_CHAR);
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtils.trimToNull((String)split[i]);
        }
        return split;
    }

    @Override
    public void addToChain(String chainName, String handlerName) {
        if (StringUtils.isBlank((CharSequence)chainName)) {
            throw new IllegalArgumentException("chainName cannot be null or empty.");
        }
        DisruptorHandler<DisruptorEvent> handler = this.getHandler(handlerName);
        if (handler == null) {
            throw new IllegalArgumentException("There is no handler with name '" + handlerName + "' to apply to chain [" + chainName + "] in the pool of available Handlers.  Ensure a handler with that name/path has first been registered with the addHandler method(s).");
        }
        NamedHandlerList<DisruptorEvent> chain = this.ensureChain(chainName);
        chain.add(handler);
    }

    protected NamedHandlerList<DisruptorEvent> ensureChain(String chainName) {
        DefaultNamedHandlerList chain = this.getChain(chainName);
        if (chain == null) {
            chain = new DefaultNamedHandlerList(chainName);
            this.handlerChains.put(chainName, chain);
        }
        return chain;
    }

    @Override
    public NamedHandlerList<DisruptorEvent> getChain(String chainName) {
        return this.handlerChains.get(chainName);
    }

    @Override
    public boolean hasChains() {
        return !CollectionUtils.isEmpty(this.handlerChains);
    }

    @Override
    public Set<String> getChainNames() {
        return this.handlerChains != null ? this.handlerChains.keySet() : Collections.EMPTY_SET;
    }

    @Override
    public HandlerChain<DisruptorEvent> proxy(HandlerChain<DisruptorEvent> original, String chainName) {
        NamedHandlerList<DisruptorEvent> configured = this.getChain(chainName);
        if (configured == null) {
            String msg = "There is no configured chain under the name/key [" + chainName + "].";
            throw new IllegalArgumentException(msg);
        }
        return configured.proxy(original);
    }
}

