/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.handler;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.disruptor.event.DisruptorEvent;
import com.taotao.cloud.disruptor.handler.DefaultHandlerChainManager;
import com.taotao.cloud.disruptor.handler.HandlerChain;
import com.taotao.cloud.disruptor.handler.HandlerChainManager;
import com.taotao.cloud.disruptor.handler.HandlerChainResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class PathMatchingHandlerChainResolver
implements HandlerChainResolver<DisruptorEvent> {
    private HandlerChainManager<DisruptorEvent> handlerChainManager;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public PathMatchingHandlerChainResolver() {
        this.handlerChainManager = new DefaultHandlerChainManager();
    }

    public HandlerChainManager<DisruptorEvent> getHandlerChainManager() {
        return this.handlerChainManager;
    }

    public void setHandlerChainManager(HandlerChainManager<DisruptorEvent> handlerChainManager) {
        this.handlerChainManager = handlerChainManager;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    @Override
    public HandlerChain<DisruptorEvent> getChain(DisruptorEvent event, HandlerChain<DisruptorEvent> originalChain) {
        HandlerChainManager<DisruptorEvent> handlerChainManager = this.getHandlerChainManager();
        if (!handlerChainManager.hasChains()) {
            return null;
        }
        String eventURI = this.getPathWithinEvent(event);
        for (String pathPattern : handlerChainManager.getChainNames()) {
            if (!this.pathMatches(pathPattern, eventURI)) continue;
            LogUtils.info((String)("Matched path pattern [" + pathPattern + "] for eventURI [" + eventURI + "].  Utilizing corresponding handler chain..."), (Object[])new Object[0]);
            return handlerChainManager.proxy(originalChain, pathPattern);
        }
        return null;
    }

    protected boolean pathMatches(String pattern, String path) {
        PathMatcher pathMatcher = this.getPathMatcher();
        return pathMatcher.match(pattern, path);
    }

    protected String getPathWithinEvent(DisruptorEvent event) {
        return event.getRouteExpression();
    }
}

