/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.disruptor.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static final char EXTENSION_SEPARATOR = '.';
    public static String CONFIG_LOCATION_DELIMITERS = ",; \t\n";
    private static final int[] allChineseScope = new int[]{1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787, 3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086, 4390, 4558, 4684, 4925, 5249, 5600, Integer.MAX_VALUE};
    public static final char unknowChar = '*';
    private static final char[] allEnglishLetter = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'W', 'X', 'Y', 'Z', '*'};

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        if (str.length() == 0) {
            return true;
        }
        return "NULL".equals(str.toUpperCase());
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isNull(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((CharSequence)str);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return StringUtils.containsWhitespace((CharSequence)str);
    }

    public static String trimWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lcStr = str.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (str == null || suffix == null) {
            return false;
        }
        if (str.endsWith(suffix)) {
            return true;
        }
        if (str.length() < suffix.length()) {
            return false;
        }
        String lcStr = str.substring(str.length() - suffix.length()).toLowerCase();
        String lcSuffix = suffix.toLowerCase();
        return lcStr.equals(lcSuffix);
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return StringUtils.replace(inString, pattern, "");
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!StringUtils.hasLength(inString) || !StringUtils.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unqualify(String qualifiedName) {
        return StringUtils.unqualify(qualifiedName, '.');
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    public static String capitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, false);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        if (capitalize) {
            sb.append(Character.toUpperCase(str.charAt(0)));
        } else {
            sb.append(Character.toLowerCase(str.charAt(0)));
        }
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String stripFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            Object newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = (String)newPath + FOLDER_SEPARATOR;
            }
            return (String)newPath + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = StringUtils.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(":");
        Object prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (((String)prefix).contains(FOLDER_SEPARATOR)) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = (String)prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return (String)prefix + StringUtils.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static boolean pathEquals(String path1, String path2) {
        return StringUtils.cleanPath(path1).equals(StringUtils.cleanPath(path2));
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = StringUtils.tokenizeToStringArray(localeString, "_ ", false, false);
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        StringUtils.validateLocalePart(language);
        StringUtils.validateLocalePart(country);
        String variant = "";
        if (parts.length > 2 && (variant = StringUtils.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country, language.length()) + country.length()))).startsWith("_")) {
            variant = StringUtils.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static void validateLocalePart(String localePart) {
        for (int i = 0; i < localePart.length(); ++i) {
            char ch = localePart.charAt(i);
            if (ch == '_' || ch == ' ' || Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
        }
    }

    public static String toLanguageTag(Locale locale) {
        return locale.getLanguage() + (String)(StringUtils.hasText(locale.getCountry()) ? "-" + locale.getCountry() : "");
    }

    public static TimeZone parseTimeZoneString(String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        if ("GMT".equals(timeZone.getID()) && !timeZoneString.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + timeZoneString + "'");
        }
        return timeZone;
    }

    public static String[] addStringToArray(String[] array, String str) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            return new String[]{str};
        }
        String[] newArr = new String[array.length + 1];
        System.arraycopy(array, 0, newArr, 0, array.length);
        newArr[array.length] = str;
        return newArr;
    }

    public static String[] concatenateStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty((Object[])array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty((Object[])array2)) {
            return array1;
        }
        String[] newArr = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArr, 0, array1.length);
        System.arraycopy(array2, 0, newArr, array1.length, array2.length);
        return newArr;
    }

    public static String[] mergeStringArrays(String[] array1, String[] array2) {
        if (ObjectUtils.isEmpty((Object[])array1)) {
            return array2;
        }
        if (ObjectUtils.isEmpty((Object[])array2)) {
            return array1;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(array1));
        for (String str : array2) {
            if (result.contains(str)) continue;
            result.add(str);
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] sortStringArray(String[] array) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            return new String[0];
        }
        Arrays.sort(array);
        return array;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<String> list = Collections.list(enumeration);
        return list.toArray(new String[list.size()]);
    }

    public static String[] trimArrayElements(String[] array) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            return new String[0];
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String element = array[i];
            result[i] = element != null ? element.trim() : null;
        }
        return result;
    }

    public static String[] removeDuplicateStrings(String[] array) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            return array;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (String element : array) {
            set.add(element);
        }
        return StringUtils.toStringArray(set);
    }

    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter) {
        return StringUtils.splitArrayElementsIntoProperties(array, delimiter, null);
    }

    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter, String charsToDelete) {
        if (ObjectUtils.isEmpty((Object[])array)) {
            return null;
        }
        Properties result = new Properties();
        for (String element : array) {
            String[] splittedElement;
            if (charsToDelete != null) {
                element = StringUtils.deleteAny(element, charsToDelete);
            }
            if ((splittedElement = StringUtils.split(element, delimiter)) == null) continue;
            result.setProperty(splittedElement[0].trim(), splittedElement[1].trim());
        }
        return result;
    }

    public static String[] tokenizeToStringArray(String str) {
        return StringUtils.tokenizeToStringArray(str, CONFIG_LOCATION_DELIMITERS, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StringUtils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(StringUtils.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return StringUtils.delimitedListToStringArray(str, ",");
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        String[] tokens;
        TreeSet<String> set = new TreeSet<String>();
        for (String token : tokens = StringUtils.commaDelimitedListToStringArray(str)) {
            set.add(token);
        }
        return set;
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (CollectionUtils.isEmpty(coll)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (ObjectUtils.isEmpty((Object[])arr)) {
            return "";
        }
        if (arr.length == 1) {
            return ObjectUtils.nullSafeToString((Object)arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return StringUtils.arrayToDelimitedString(arr, ",");
    }

    public static Map<String, String> getMapFromQueryParamString(String str) {
        HashMap<String, String> param = new HashMap<String, String>();
        String[] keyValues = str.split("`");
        for (int i = 0; i < keyValues.length; ++i) {
        }
        return param;
    }

    public static String replaceAll(String src, String tar, String str) {
        StringBuilder sb = new StringBuilder();
        byte[] bytesSrc = src.getBytes();
        byte[] bytes = str.getBytes();
        int point = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (!StringUtils.isStartWith(bytes, i, bytesSrc, 0)) continue;
            sb.append(new String(bytes, point, i));
            sb.append(tar);
            point = i += bytesSrc.length;
        }
        sb.append(new String(bytes, point, bytes.length));
        return sb.toString();
    }

    private static boolean isStartWith(byte[] bytesSrc, int startSrc, byte[] bytesTar, int startTar) {
        for (int j = startTar; j < bytesTar.length; ++j) {
            if (bytesSrc[startSrc + j] == bytesTar[j]) continue;
            return false;
        }
        return true;
    }

    public static char getFirstLetterFromChinessWord(String str) {
        char result = '*';
        String temp = str.toUpperCase();
        try {
            byte[] bytes = temp.getBytes("gbk");
            if (bytes[0] < 128 && bytes[0] > 0) {
                return (char)bytes[0];
            }
            int gbkIndex = 0;
            int i = 0;
            while (i < bytes.length) {
                int n = i++;
                bytes[n] = (byte)(bytes[n] - 160);
            }
            gbkIndex = bytes[0] * 100 + bytes[1];
            for (i = 0; i < allEnglishLetter.length; ++i) {
                if (i == 22) {
                    // empty if block
                }
                if (gbkIndex < allChineseScope[i] || gbkIndex >= allChineseScope[i + 1]) continue;
                result = allEnglishLetter[i];
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String[] split(String src, char letter) {
        if (src == null) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        byte[] bytes = src.getBytes();
        int curPoint = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != letter) continue;
            String s = new String(bytes, curPoint, i - curPoint);
            ret.add(s);
            curPoint = i + 1;
        }
        if (ret.size() == 0) {
            return new String[]{src};
        }
        String[] retStr = new String[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            retStr[i] = (String)ret.get(i);
        }
        return retStr;
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!StringUtils.hasLength(toSplit) || !StringUtils.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String[] splits(String toSplit, String regex) {
        if (!StringUtils.hasLength(toSplit) || !StringUtils.hasLength(regex)) {
            return new String[0];
        }
        return toSplit.split(regex);
    }

    public static String removeLast(String str) {
        if (StringUtils.isNull(str)) {
            return str;
        }
        return str.substring(0, str.length() - 1);
    }

    public static String addQuotation(String str) {
        if (str == null) {
            return null;
        }
        Object newStr = "";
        String[] strs = StringUtils.split(str, ",");
        for (int i = 0; i < strs.length; ++i) {
            if (i > 0) {
                newStr = (String)newStr + ",";
            }
            newStr = (String)newStr + "'" + strs[i] + "'";
        }
        return newStr;
    }

    public static String[] listToArray(List<String> list) {
        String[] strs = new String[list.size()];
        return list.toArray(strs);
    }

    public static String listToString(List<String> list, String separator) {
        return StringUtils.join((Object[])StringUtils.listToArray(list), (String)separator);
    }

    public static String genRandomNum(int pwd_len) {
        int maxNum = 37;
        int count = 0;
        char[] str = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_'};
        StringBuilder pwd = new StringBuilder("");
        Random r = new Random();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(37));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static String killNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String parentheses(String source) {
        return source != null ? "(" + source + ")" : null;
    }

    public static String brackets(String source) {
        return source != null ? "[" + source + "]" : null;
    }

    public static String ditto(String source) {
        return source != null ? "\"" + source + "\"" : null;
    }

    public static String quote(String str) {
        return str != null ? "'" + str + "'" : null;
    }

    public static String quote(String[] array, String separator) {
        if (null != array && array.length != 0) {
            Object[] last = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                last[i] = StringUtils.quote(array[i]);
            }
            return StringUtils.join((Object[])last, (String)separator);
        }
        return "";
    }

    public static Object quoteIfString(Object obj) {
        return obj instanceof String ? StringUtils.quote((String)obj) : obj;
    }

    public static String trimToAlphaString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return string.replaceAll("[^\\w]", "");
    }

    public static String[] trimToAlphaStrings(String string) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        char[] chars = string.replaceAll("[^\\w]", "").toCharArray();
        String[] strs = new String[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            strs[i] = String.valueOf(chars[i]);
        }
        return strs;
    }

    public static String trimToString(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return str.trim();
    }
}

