/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dozer.configuration;

import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.spring.DozerBeanMapperFactoryBean;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.dozer.helper.DozerHelper;
import com.taotao.cloud.dozer.properties.DozerProperties;
import java.io.IOException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnMissingBean(value={Mapper.class})
@EnableConfigurationProperties(value={DozerProperties.class})
@ConditionalOnClass(value={DozerBeanMapperFactoryBean.class, Mapper.class})
@ConditionalOnProperty(prefix="taotao.cloud.dozer", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class DozerAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(DozerAutoConfiguration.class, (String)"taotao-cloud-starter-dozer", (String[])new String[0]);
    }

    @Bean
    public DozerHelper dozerHelper(Mapper mapper) {
        return new DozerHelper(mapper);
    }

    @Bean
    public DozerBeanMapperFactoryBean dozerMapper(DozerProperties properties) throws IOException {
        DozerBeanMapperFactoryBean factoryBean = new DozerBeanMapperFactoryBean();
        factoryBean.setMappingFiles(properties.resolveMapperLocations());
        return factoryBean;
    }
}

