/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dozer.helper;

import com.github.dozermapper.core.Mapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DozerHelper {
    private final Mapper mapper;

    public DozerHelper(Mapper mapper) {
        this.mapper = mapper;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public <T> T map(Object source, Class<T> destinationClass) {
        if (source == null) {
            return null;
        }
        return (T)this.mapper.map(source, destinationClass);
    }

    public <T> T map2(Object source, Class<T> destinationClass) {
        if (source == null) {
            try {
                return destinationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)this.mapper.map(source, destinationClass);
    }

    public void map(Object source, Object destination) {
        if (source == null) {
            return;
        }
        this.mapper.map(source, destination);
    }

    public <T> T map(Object source, Class<T> destinationClass, String mapId) {
        if (source == null) {
            return null;
        }
        return (T)this.mapper.map(source, destinationClass, mapId);
    }

    public void map(Object source, Object destination, String mapId) {
        if (source == null) {
            return;
        }
        this.mapper.map(source, destination, mapId);
    }

    public <T, E> List<T> mapList(Collection<E> sourceList, Class<T> destinationClass) {
        return this.mapPage(sourceList, destinationClass);
    }

    public <T, E> List<T> mapPage(Collection<E> sourceList, Class<T> destinationClass) {
        if (sourceList == null || sourceList.isEmpty() || destinationClass == null) {
            return Collections.emptyList();
        }
        return sourceList.parallelStream().filter(Objects::nonNull).map(sourceObject -> this.mapper.map(sourceObject, destinationClass)).collect(Collectors.toList());
    }

    public <T, E> Set<T> mapSet(Collection<E> sourceList, Class<T> destinationClass) {
        if (sourceList == null || sourceList.isEmpty() || destinationClass == null) {
            return Collections.emptySet();
        }
        return sourceList.parallelStream().map(sourceObject -> this.mapper.map(sourceObject, destinationClass)).collect(Collectors.toSet());
    }
}

