/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dozer.properties;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@RefreshScope
@ConfigurationProperties(prefix="taotao.cloud.dozer")
public class DozerProperties {
    public static final String PREFIX = "taotao.cloud.dozer";
    private boolean enabled = true;
    private static final ResourcePatternResolver PATTERN_RESOLVER = new PathMatchingResourcePatternResolver();
    private String[] mappingFiles = new String[]{"classpath*:dozer/*.dozer.xml"};

    public String[] getMappingFiles() {
        return Arrays.copyOf(this.mappingFiles, this.mappingFiles.length);
    }

    public DozerProperties setMappingFiles(String[] mappingFiles) {
        this.mappingFiles = Arrays.copyOf(mappingFiles, mappingFiles.length);
        return this;
    }

    public Resource[] resolveMapperLocations() {
        return (Resource[])Stream.of(Optional.ofNullable(this.mappingFiles).orElse(new String[0])).flatMap(location -> Stream.of(this.getResources((String)location))).toArray(Resource[]::new);
    }

    private Resource[] getResources(String location) {
        try {
            return PATTERN_RESOLVER.getResources(location);
        }
        catch (IOException var3) {
            return new Resource[0];
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

