/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dubbo.filter;

import com.google.common.base.Stopwatch;
import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.dubbo.properties.DubboProperties;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.GenericService;

@Activate(group={"provider", "consumer"})
public class DubboRequestFilter
implements Filter {
    private boolean requestLog;

    public void DubboRequestFilter() {
        DubboProperties dubboProperties = (DubboProperties)ContextUtils.getBean(DubboProperties.class, (boolean)true);
        this.requestLog = dubboProperties.isRequestLog();
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (!this.requestLog) {
            return invoker.invoke(invocation);
        }
        String client = "provider";
        if (RpcContext.getServiceContext().isConsumerSide()) {
            client = "consumer";
        }
        String baselog = "Client[" + client + "],InterfaceName=[" + invocation.getInvoker().getInterface().getSimpleName() + "],MethodName=[" + invocation.getMethodName() + "]";
        LogUtils.info((String)"DUBBO - \u670d\u52a1\u8c03\u7528: {},Parameter={}", (Object[])new Object[]{baselog, invocation.getArguments()});
        Stopwatch stopwatch = Stopwatch.createStarted();
        Result result = invoker.invoke(invocation);
        if (result.hasException() && invoker.getInterface().equals(GenericService.class)) {
            LogUtils.error((String)"DUBBO - \u670d\u52a1\u5f02\u5e38: {},Exception={}", (Object[])new Object[]{baselog, result.getException()});
        } else {
            LogUtils.info((String)"DUBBO - \u670d\u52a1\u54cd\u5e94: {},SpendTime=[{}ms],Response={}", (Object[])new Object[]{baselog, stopwatch.elapsed(TimeUnit.MILLISECONDS), JsonUtils.toJSONString((Object)new Object[]{result.getValue()})});
        }
        return result;
    }
}

