/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dubbo.filter;

import com.taotao.cloud.common.context.TraceContextHolder;
import com.taotao.cloud.common.utils.common.IdGeneratorUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.common.utils.servlet.TraceUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider", "consumer"})
public class DubboTraceFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        LogUtils.info((String)"DubboTraceFilter activate ------------------------------", (Object[])new Object[0]);
        boolean isProviderSide = RpcContext.getServerContext().isProviderSide();
        if (isProviderSide) {
            traceId = invocation.getAttachment("taotao-cloud-trace-id");
            if (StringUtils.isEmpty((String)traceId)) {
                traceId = IdGeneratorUtils.getIdStr();
                TraceContextHolder.setTraceId((String)traceId);
                TraceUtils.setMdcTraceId((String)traceId);
            } else {
                TraceContextHolder.setTraceId((String)traceId);
                TraceUtils.setMdcTraceId((String)traceId);
            }
        } else {
            traceId = TraceUtils.getTraceId();
            if (!StringUtils.isEmpty((String)traceId)) {
                invocation.setAttachment("taotao-cloud-trace-id", traceId);
            }
        }
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            if (isProviderSide) {
                TraceContextHolder.clear();
            }
        }
    }
}

