/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dubbo.filter;

import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.validation.Validation;
import org.apache.dubbo.validation.Validator;

@Activate(group={"provider", "consumer"})
public class DubboValidationFilter
implements Filter {
    private Validation validation;

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public org.apache.dubbo.rpc.Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        LogUtils.info((String)"DubboValidationFilter activate ------------------------------", (Object[])new Object[0]);
        if (this.validation != null && !invocation.getMethodName().startsWith("$") && ConfigUtils.isNotEmpty((String)invoker.getUrl().getMethodParameter(invocation.getMethodName(), "validation"))) {
            try {
                Validator validator = this.validation.getValidator(invoker.getUrl());
                if (validator != null) {
                    validator.validate(invocation.getMethodName(), invocation.getParameterTypes(), invocation.getArguments());
                }
            }
            catch (RpcException e) {
                throw e;
            }
            catch (ConstraintViolationException e) {
                Set violations = e.getConstraintViolations();
                if (CollectionUtils.isNotEmpty((Collection)violations)) {
                    ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
                    Result result = Result.fail((String)violation.getMessage(), (int)ResultEnum.ERROR.getCode());
                    return AsyncRpcResult.newDefaultAsyncResult((Object)result, (Invocation)invocation);
                }
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)new ValidationException(e.getMessage()), (Invocation)invocation);
            }
            catch (Throwable t) {
                return AsyncRpcResult.newDefaultAsyncResult((Throwable)t, (Invocation)invocation);
            }
        }
        return invoker.invoke(invocation);
    }
}

