/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.dubbo.treadpool;

import com.taotao.cloud.common.utils.log.LogUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadpool.support.fixed.FixedThreadPool;
import org.jetbrains.annotations.NotNull;

public class DubboWatchingPool
extends FixedThreadPool
implements Runnable {
    private static final double ALARM_PERCENT = 0.75;
    private final Map<URL, ThreadPoolExecutor> theadPoolMap = new ConcurrentHashMap<URL, ThreadPoolExecutor>();

    public DubboWatchingPool() {
        new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(Thread.currentThread().getThreadGroup(), r, "taotao-cloud-dubbo-watchingPool");
            }
        }).scheduleWithFixedDelay(this, 1L, 3L, TimeUnit.SECONDS);
    }

    public Executor getExecutor(URL url) {
        Executor executor = super.getExecutor(url);
        if (executor instanceof ThreadPoolExecutor) {
            this.theadPoolMap.put(url, (ThreadPoolExecutor)executor);
        }
        return executor;
    }

    @Override
    public void run() {
        for (Map.Entry<URL, ThreadPoolExecutor> entry : this.theadPoolMap.entrySet()) {
            URL url = entry.getKey();
            ThreadPoolExecutor threadPoolExecutor = entry.getValue();
            int activeCount = threadPoolExecutor.getActiveCount();
            int corePoolSize = threadPoolExecutor.getCorePoolSize();
            double percent = (double)activeCount / ((double)corePoolSize * 1.0);
            LogUtils.info((String)"\u7ebf\u7a0b\u6c60\u72b6\u6001\uff1a{}/{},: {}%", (Object[])new Object[]{activeCount, corePoolSize, percent * 100.0});
            if (!(percent > 0.75)) continue;
            LogUtils.error((String)"\u8d85\u51fa\u8b66\u6212\u7ebf : host:{}, \u5f53\u524d\u4f7f\u7528\u91cf {}%, URL:{}", (Object[])new Object[]{url.getHost(), percent * 100.0, url});
        }
    }
}

