/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.elk.configuration;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.exception.BaseException;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.elk.filter.LogStatisticsFilter;
import com.taotao.cloud.elk.properties.ElkHealthLogStatisticProperties;
import com.taotao.cloud.elk.properties.ElkProperties;
import com.taotao.cloud.elk.properties.ElkWebAspectProperties;
import com.taotao.cloud.elk.properties.ElkWebProperties;
import javax.annotation.Resource;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import net.logstash.logback.encoder.LogstashEncoder;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={ElkProperties.class, ElkWebAspectProperties.class, ElkHealthLogStatisticProperties.class, ElkWebProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.elk", name={"enabled"}, havingValue="true")
public class ElkAutoConfiguration
implements InitializingBean {
    @Resource
    private ElkProperties elkProperties;
    @Resource
    private LogStatisticsFilter logStatisticsFilter;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ElkAutoConfiguration.class, (String)"taotao-cloud-starter-elk", (String[])new String[0]);
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public LogstashTcpSocketAppender logstashTcpSocketAppender() {
        LogstashTcpSocketAppender appender = new LogstashTcpSocketAppender();
        String[] destinations = this.elkProperties.getDestinations();
        if (this.elkProperties.getDestinations() == null || this.elkProperties.getDestinations().length == 0) {
            throw new BaseException("\u672a\u8bbe\u7f6eelk\u5730\u5740");
        }
        for (String destination : destinations) {
            appender.addDestination(destination);
        }
        appender.setEncoder(this.createEncoder());
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if (factory instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)factory;
            appender.setContext((Context)context);
            context.getLogger("ROOT").addAppender((Appender)appender);
        }
        if (this.logStatisticsFilter != null) {
            appender.addFilter((Filter)this.logStatisticsFilter);
        }
        return appender;
    }

    @Bean
    @ConditionalOnProperty(prefix="taotao.cloud.elk.log.statistic", name={"enabled"}, havingValue="true")
    LogStatisticsFilter getLogStatisticsFilter() {
        return new LogStatisticsFilter();
    }

    private Encoder<ILoggingEvent> createEncoder() {
        LogstashEncoder encoder = new LogstashEncoder();
        String appName = this.elkProperties.getAppName();
        if (StrUtil.isBlank((CharSequence)appName)) {
            appName = this.elkProperties.getSpringAppName();
        }
        if (StrUtil.isBlank((CharSequence)appName)) {
            throw new BaseException("\u7f3a\u5c11appName\u914d\u7f6e");
        }
        encoder.setCustomFields("{\"appname\":\"" + appName + "\",\"appindex\":\"applog\"}");
        encoder.setEncoding("UTF-8");
        return encoder;
    }
}

