/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.encrypt.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.encrypt.annotation.SignEncrypt;
import com.taotao.cloud.encrypt.enums.EncryptType;
import com.taotao.cloud.encrypt.exception.EncryptException;
import com.taotao.cloud.encrypt.handler.EncryptHandler;
import com.taotao.cloud.encrypt.handler.SignEncryptHandler;
import com.taotao.cloud.encrypt.handler.impl.AesEncryptHandler;
import com.taotao.cloud.encrypt.handler.impl.Base64EncryptHandler;
import com.taotao.cloud.encrypt.handler.impl.RsaEncryptHandler;
import com.taotao.cloud.encrypt.handler.impl.SignEncryptHandlerImpl;
import com.taotao.cloud.encrypt.interceptor.SignEncryptInterceptor;
import com.taotao.cloud.encrypt.properties.EncryptFilterProperties;
import com.taotao.cloud.encrypt.properties.EncryptProperties;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@AutoConfiguration
@EnableConfigurationProperties(value={EncryptProperties.class, EncryptFilterProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.encrypt", name={"enabled"}, havingValue="true")
public class EncryptAutoConfiguration
implements ApplicationContextAware,
BeanFactoryPostProcessor,
EnvironmentAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private Environment environment;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(EncryptAutoConfiguration.class, (String)"taotao-cloud-starter-encrypt", (String[])new String[0]);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)configurableListableBeanFactory;
        GenericBeanDefinition bean = new GenericBeanDefinition();
        EncryptType type = (EncryptType)((Object)this.environment.getProperty("encrypt.type", EncryptType.class));
        String secret = (String)this.environment.getProperty("encrypt.secret", String.class);
        String publicKey = (String)this.environment.getProperty("encrypt.publicKey", String.class);
        String privateKey = (String)this.environment.getProperty("encrypt.privateKey", String.class);
        Boolean debug = (Boolean)this.environment.getProperty("encrypt.debug", Boolean.TYPE);
        if (debug != null && debug.booleanValue()) {
            return;
        }
        if (type == null) {
            throw new EncryptException("\u6ca1\u6709\u5b9a\u4e49\u52a0\u5bc6\u7c7b\u578b(No encryption type is defined)");
        }
        switch (type) {
            case BASE64: {
                bean.setBeanClass(Base64EncryptHandler.class);
                bean.setPrimary(true);
                beanFactory.registerBeanDefinition("encryptHandler", (BeanDefinition)bean);
                break;
            }
            case AES: {
                if (secret == null || "".equals(secret.trim())) {
                    throw new EncryptException("\u6ca1\u6709\u5b9a\u4e49\u79d8\u94a5(No secret key is defined)");
                }
                bean.setBeanClass(AesEncryptHandler.class);
                bean.getPropertyValues().add("secret", (Object)secret);
                bean.setPrimary(true);
                beanFactory.registerBeanDefinition("encryptHandler", (BeanDefinition)bean);
                break;
            }
            case RSA: {
                if (publicKey == null || "".equals(publicKey.trim())) {
                    throw new EncryptException("\u6ca1\u6709\u5b9a\u4e49\u516c\u94a5(No publicKey is defined)");
                }
                if (privateKey == null || "".equals(privateKey.trim())) {
                    throw new EncryptException("\u6ca1\u6709\u5b9a\u4e49\u79c1\u94a5(No privateKey is defined)");
                }
                bean.setBeanClass(RsaEncryptHandler.class);
                bean.getPropertyValues().add("publicKey", (Object)publicKey);
                bean.getPropertyValues().add("privateKey", (Object)privateKey);
                bean.setPrimary(true);
                beanFactory.registerBeanDefinition("encryptHandler", (BeanDefinition)bean);
                break;
            }
            case CUSTOM: {
                try {
                    beanFactory.getBean(EncryptHandler.class);
                    break;
                }
                catch (Exception e) {
                    throw new EncryptException("\u6ca1\u6709\u81ea\u5b9a\u4e49\u52a0\u5bc6\u5904\u7406\u5668(No custom encryption processor)");
                }
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Configuration
    @ConditionalOnExpression(value="environment.getProperty('encrypt.signSecret')!=null && environment.getProperty('encrypt.signSecret').trim()!=''")
    public static class SignEncryptConfiguration
    implements InitializingBean {
        @Autowired
        private SignEncryptHandler signEncryptHandler;

        public void afterPropertiesSet() throws Exception {
            LogUtils.started(SignEncryptConfiguration.class, (String)"taotao-cloud-starter-encrypt", (String[])new String[0]);
        }

        @Bean
        @ConditionalOnMissingBean(value={SignEncryptHandler.class})
        public SignEncryptHandler sortSignEncryptHandlerDefult() {
            return new SignEncryptHandlerImpl();
        }

        @Bean
        public DefaultPointcutAdvisor sortSignEncryptAdvisor(@Value(value="${encrypt.signSecret}") String sortSignSecret) {
            SignEncryptInterceptor interceptor = new SignEncryptInterceptor(sortSignSecret, this.signEncryptHandler);
            AnnotationMatchingPointcut pointcut = new AnnotationMatchingPointcut(null, SignEncrypt.class);
            DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
            advisor.setPointcut((Pointcut)pointcut);
            advisor.setAdvice((Advice)interceptor);
            return advisor;
        }
    }
}

