/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.encrypt.wrapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CacheRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body;

    public byte[] getBody() {
        return this.body;
    }

    public CacheRequestWrapper(HttpServletRequest request) throws IOException, ServletException {
        super(request);
        ServletInputStream inputStream = request.getInputStream();
        String header = request.getHeader("Content-Length");
        if (header == null) {
            return;
        }
        int contentLength = Integer.parseInt(header);
        byte[] bytes = new byte[contentLength];
        for (int readCount = 0; readCount < contentLength; readCount += inputStream.read(bytes, readCount, contentLength - readCount)) {
        }
        this.body = bytes;
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public boolean isFinished() {
                return byteArrayInputStream.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
    }
}

