/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.faility.alibaba.listener;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.discovery.NacosDiscoveryClient;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.taotao.cloud.common.utils.log.LogUtils;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
public class NacosServiceListener
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(NacosServiceListener.class, (String)"taotao-cloud-starter-core", (String[])new String[0]);
    }

    @Configuration
    public static class StandardNacosServiceListener
    implements InitializingBean {
        @Autowired
        private NacosServiceManager nacosServiceManager;
        @Autowired
        private NacosDiscoveryProperties properties;
        @Autowired
        private NacosDiscoveryClient discoveryClient;

        public void afterPropertiesSet() throws Exception {
            this.nacosServiceManager.getNamingService().subscribe(this.properties.getService(), this.properties.getGroup(), Collections.singletonList(this.properties.getClusterName()), event -> {
                if (event instanceof NamingEvent) {
                    List instances = ((NamingEvent)event).getInstances();
                    LogUtils.info((String)"", (Object[])new Object[0]);
                }
            });
            List services = this.discoveryClient.getServices();
            if (!services.isEmpty()) {
                for (String service : services) {
                    this.nacosServiceManager.getNamingService().subscribe(service, this.properties.getGroup(), List.of(this.properties.getClusterName()), event -> {
                        if (event instanceof NamingEvent) {
                            List instances = ((NamingEvent)event).getInstances();
                            LogUtils.info((String)"", (Object[])new Object[0]);
                        }
                    });
                }
            }
        }
    }
}

