/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.feign.configuration;

import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.constant.CommonConstant;
import com.taotao.cloud.common.context.TenantContextHolder;
import com.taotao.cloud.common.utils.common.IdGeneratorUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import feign.RequestInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.cloud.feign.interceptor", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class FeignInterceptorAutoConfiguration
implements InitializingBean {
    protected List<String> requestHeaders = new ArrayList<String>();
    public static final List<String> HEADER_NAME_LIST = Arrays.asList("tenant", "sub_tenant", "userid", "account", "name", "gray_version", "x-trace-header", "X-Real-IP", "x-forwarded-for");

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(FeignInterceptorAutoConfiguration.class, (String)"taotao-cloud-starter-feign", (String[])new String[0]);
    }

    @PostConstruct
    public void initialize() {
        this.requestHeaders.add("taotao-cloud-user-id-header");
        this.requestHeaders.add("taotao-cloud-user-name-header");
        this.requestHeaders.add("taotao-cloud-user-role-header");
        this.requestHeaders.add(CommonConstant.TAOTAO_CLOUD_VERSION);
    }

    @Bean
    public RequestInterceptor httpFeignInterceptor() {
        LogUtils.started(RequestInterceptor.class, (String)"taotao-cloud-starter-feign", (String[])new String[0]);
        return template -> {
            String tenant;
            RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                String token;
                ServletRequestAttributes attributes = (ServletRequestAttributes)requestAttributes;
                HttpServletRequest request = attributes.getRequest();
                Enumeration headerNames = request.getHeaderNames();
                if (headerNames != null) {
                    while (headerNames.hasMoreElements()) {
                        String headerName = (String)headerNames.nextElement();
                        String values = request.getHeader(headerName);
                        if (StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"Content-Length")) continue;
                        if (StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)"User-Agent")) {
                            values = StringUtils.replace((String)values, (String)"", (String)String.valueOf(' '));
                        }
                        template.header(headerName, new String[]{values});
                    }
                }
                if (StrUtil.isEmpty((CharSequence)(token = this.extractHeaderToken(request)))) {
                    token = request.getParameter("access_token");
                }
                if (StrUtil.isNotEmpty((CharSequence)token)) {
                    template.header("Authorization", new String[]{"bearea " + token});
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)(tenant = TenantContextHolder.getTenant()))) {
                template.header("taotao-cloud-tenant-header", new String[]{tenant});
            }
            String traceId = MDC.get((String)"taotao-cloud-trace-id");
            template.header("taotao-cloud-trace-header", new String[]{StrUtil.isNotEmpty((CharSequence)traceId) ? traceId : IdGeneratorUtils.getIdStr()});
            template.header("taotao-cloud-from-inner", new String[]{"true"});
        };
    }

    private String extractHeaderToken(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            if (!value.startsWith("bearea")) continue;
            String authHeaderValue = value.substring("bearea".length()).trim();
            int commaIndex = authHeaderValue.indexOf(44);
            if (commaIndex > 0) {
                authHeaderValue = authHeaderValue.substring(0, commaIndex);
            }
            return authHeaderValue;
        }
        return null;
    }
}

