/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.feign.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.feign.annotation.ConditionalOnFeignUseHttpClient;
import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

@AutoConfiguration
@ConditionalOnFeignUseHttpClient
public class HttpClientAutoConfiguration
implements InitializingBean {
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), r, "taotao-cloud-feign-httpclient-timer");
            thread.setDaemon(true);
            return thread;
        }
    });
    @Autowired(required=false)
    private RegistryBuilder registryBuilder;
    private CloseableHttpClient httpClient;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(HttpClientAutoConfiguration.class, (String)"taotao-cloud-starter-feign", (String[])new String[0]);
    }

    @PostConstruct
    public void postConstruct() {
        LogUtils.started(HttpClientAutoConfiguration.class, (String)"taotao-cloud-starter-feign", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpClientConnectionManager.class})
    public HttpClientConnectionManager connectionManager(ApacheHttpClientConnectionManagerFactory connectionManagerFactory, FeignHttpClientProperties feignHttpClientProperties) {
        HttpClientConnectionManager connectionManager = connectionManagerFactory.newConnectionManager(feignHttpClientProperties.isDisableSslValidation(), feignHttpClientProperties.getMaxConnections(), feignHttpClientProperties.getMaxConnectionsPerRoute(), feignHttpClientProperties.getTimeToLive(), feignHttpClientProperties.getTimeToLiveUnit(), this.registryBuilder);
        this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(() -> ((HttpClientConnectionManager)connectionManager).closeExpiredConnections(), 30000L, feignHttpClientProperties.getConnectionTimerRepeat(), TimeUnit.MILLISECONDS);
        return connectionManager;
    }

    @Bean
    public CloseableHttpClient httpClient(ApacheHttpClientFactory httpClientFactory, HttpClientConnectionManager httpClientConnectionManager, FeignHttpClientProperties feignHttpClientProperties) {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(feignHttpClientProperties.getConnectionTimeout()).setRedirectsEnabled(feignHttpClientProperties.isFollowRedirects()).build();
        this.httpClient = httpClientFactory.createBuilder().setConnectionManager(httpClientConnectionManager).setDefaultRequestConfig(defaultRequestConfig).build();
        return this.httpClient;
    }

    @Bean
    public ClientHttpRequestFactory clientHttpRequestFactory(CloseableHttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        LogUtils.info((String)"Bean [Client Http Request Factory for HttpClient] Auto Configure.", (Object[])new Object[0]);
        return httpComponentsClientHttpRequestFactory;
    }

    @PreDestroy
    public void destroy() {
        this.scheduledThreadPoolExecutor.shutdown();
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                LogUtils.info((String)" Could not correctly close httpClient.", (Object[])new Object[0]);
            }
        }
    }
}

