/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.feign.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.feign.annotation.ConditionalOnFeignUseOkHttp;
import com.taotao.cloud.feign.okhttp.OkHttpResponseInterceptor;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.cloud.openfeign.FeignClientProperties;
import org.springframework.cloud.openfeign.loadbalancer.FeignLoadBalancerAutoConfiguration;
import org.springframework.cloud.openfeign.support.FeignHttpClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;

@AutoConfiguration(before={FeignLoadBalancerAutoConfiguration.class})
@ConditionalOnFeignUseOkHttp
public class OkHttpAutoConfiguration
implements InitializingBean {
    private OkHttpClient okHttpClient;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(OkHttpAutoConfiguration.class, (String)"taotao-cloud-starter-feign", (String[])new String[0]);
    }

    @PostConstruct
    public void postConstruct() {
        LogUtils.started(OkHttpAutoConfiguration.class, (String)"taotao-cloud-starter-feign", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean(value={ConnectionPool.class})
    public ConnectionPool connectionPool(FeignHttpClientProperties feignHttpClientProperties, OkHttpClientConnectionPoolFactory connectionPoolFactory) {
        int maxTotalConnections = feignHttpClientProperties.getMaxConnections();
        long timeToLive = feignHttpClientProperties.getTimeToLive();
        TimeUnit ttlUnit = feignHttpClientProperties.getTimeToLiveUnit();
        return connectionPoolFactory.create(maxTotalConnections, timeToLive, ttlUnit);
    }

    @Bean
    public OkHttpClient okHttpClient(OkHttpClientFactory okHttpClientFactory, ConnectionPool connectionPool, FeignClientProperties feignClientProperties, FeignHttpClientProperties feignHttpClientProperties) {
        FeignClientProperties.FeignClientConfiguration defaultConfig = (FeignClientProperties.FeignClientConfiguration)feignClientProperties.getConfig().get("default");
        int readTimeout = 5000;
        if (Objects.nonNull(defaultConfig)) {
            readTimeout = defaultConfig.getReadTimeout();
        }
        int connectTimeout = feignHttpClientProperties.getConnectionTimeout();
        boolean disableSslValidation = feignHttpClientProperties.isDisableSslValidation();
        boolean followRedirects = feignHttpClientProperties.isFollowRedirects();
        this.okHttpClient = okHttpClientFactory.createBuilder(disableSslValidation).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).followRedirects(followRedirects).connectionPool(connectionPool).addInterceptor((Interceptor)new OkHttpResponseInterceptor()).build();
        return this.okHttpClient;
    }

    @Bean
    public ClientHttpRequestFactory clientHttpRequestFactory(OkHttpClient okHttpClient) {
        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory(okHttpClient);
        LogUtils.info((String)"Bean [Client Http Request Factory for OkHttp] Auto Configure.", (Object[])new Object[0]);
        return factory;
    }

    @PreDestroy
    public void destroy() {
        if (this.okHttpClient != null) {
            this.okHttpClient.dispatcher().executorService().shutdown();
            this.okHttpClient.connectionPool().evictAll();
        }
    }
}

