/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.feign.configuration;

import cn.hutool.core.lang.ParameterizedTypeImpl;
import com.alibaba.cloud.sentinel.feign.SentinelFeignAutoConfiguration;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.alibaba.fastjson.support.springfox.SwaggerJsonSerializer;
import com.taotao.cloud.common.exception.FeignErrorException;
import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.common.utils.common.JsonUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.feign.annotation.Inner;
import com.taotao.cloud.feign.endpoint.FeignClientEndpoint;
import com.taotao.cloud.feign.formatter.DateFormatRegister;
import com.taotao.cloud.feign.model.FeignExceptionResult;
import com.taotao.cloud.feign.properties.FeignInterceptorProperties;
import com.taotao.cloud.feign.properties.FeignProperties;
import com.taotao.cloud.feign.properties.LoadbalancerProperties;
import feign.Contract;
import feign.FeignException;
import feign.Logger;
import feign.MethodMetadata;
import feign.Response;
import feign.Retryer;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.form.spring.SpringFormEncoder;
import feign.optionals.OptionalDecoder;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.support.HttpMessageConverterCustomizer;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;

@EnableFeignClients(basePackages={"com.taotao.cloud.*.api.feign"})
@AutoConfiguration(before={SentinelFeignAutoConfiguration.class})
@EnableConfigurationProperties(value={LoadbalancerProperties.class, FeignProperties.class, FeignInterceptorProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.feign", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class StandardFeignAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(StandardFeignAutoConfiguration.class, (String)"taotao-cloud-starter-feign", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    public Contract contract() {
        return new FeignInnerContract();
    }

    @Bean
    public Logger.Level feignLoggerLevel() {
        return Logger.Level.FULL;
    }

    @Bean
    public DateFormatRegister dateFormatRegister() {
        return new DateFormatRegister();
    }

    @Bean
    public Retryer retryer() {
        return new Retryer.Default();
    }

    @Bean
    @Primary
    @Scope(value="prototype")
    public Encoder multipartFormEncoder(ObjectFactory<HttpMessageConverters> messageConverters) {
        return new SpringFormEncoder((Encoder)new SpringEncoder(messageConverters));
    }

    @Bean
    public Decoder feignDecoder(ObjectFactory<HttpMessageConverters> messageConverters, ObjectProvider<HttpMessageConverterCustomizer> customizers) {
        return new OptionalDecoder((Decoder)new ResultDecode((Decoder)new SpringDecoder(messageConverters, customizers)));
    }

    @Bean
    public FeignClientErrorDecoder feignClientErrorDecoder() {
        return new FeignClientErrorDecoder();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public FeignClientEndpoint feignClientEndpoint(ApplicationContext context) {
        return new FeignClientEndpoint(context);
    }

    private ObjectFactory<HttpMessageConverters> feignHttpMessageConverter() {
        HttpMessageConverters httpMessageConverters = new HttpMessageConverters(new HttpMessageConverter[]{this.getFastJsonConverter()});
        return () -> httpMessageConverters;
    }

    private FastJsonHttpMessageConverter getFastJsonConverter() {
        FastJsonHttpMessageConverter converter = new FastJsonHttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        MediaType mediaTypeJson = MediaType.valueOf((String)"application/json");
        supportedMediaTypes.add(mediaTypeJson);
        converter.setSupportedMediaTypes(supportedMediaTypes);
        FastJsonConfig config = new FastJsonConfig();
        config.getSerializeConfig().put(JSON.class, (ObjectSerializer)new SwaggerJsonSerializer());
        config.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        converter.setFastJsonConfig(config);
        return converter;
    }

    public static class FeignInnerContract
    extends SpringMvcContract {
        protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
            Inner inner;
            if (Inner.class.isInstance(methodAnnotation) && ObjectUtils.isNotEmpty((Object)(inner = (Inner)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Inner.class)))) {
                LogUtils.debug((String)"Found inner annotation on Feign interface, add header!", (Object[])new Object[0]);
                data.template().header("taotao-cloud-from-inner", new String[]{"true"});
            }
            super.processAnnotationOnMethod(data, methodAnnotation, method);
        }
    }

    public static class ResultDecode
    extends ResponseEntityDecoder {
        public ResultDecode(Decoder decoder) {
            super(decoder);
        }

        public Object decode(Response response, Type type) throws IOException, FeignException {
            Object object;
            ParameterizedType parameterizedType;
            if (type != null && type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() != Result.class && (object = super.decode(response, type = new ParameterizedTypeImpl(new Type[]{type}, null, Result.class))) instanceof Result) {
                Result result = (Result)object;
                if (result.getCode() != 200) {
                    LogUtils.error((String)"\u8c03\u7528Feign\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff0c\u63a5\u53e3:{}, \u5f02\u5e38: {}", (Object[])new Object[]{response.request().url(), result.getErrorMsg()});
                    throw new FeignErrorException(Integer.valueOf(result.getCode()), result.getErrorMsg());
                }
                return result;
            }
            return super.decode(response, type);
        }
    }

    public static class FeignClientErrorDecoder
    implements ErrorDecoder {
        public Exception decode(String methodKey, Response response) {
            String errorContent = "\u5185\u90e8\u670d\u52a1\u8c03\u7528\u9519\u8bef";
            try {
                String res = Util.toString((Reader)response.body().asReader(StandardCharsets.UTF_8));
                LogUtils.error((String)"feign\u8c03\u7528\u5f02\u5e38{}", (Object[])new Object[]{res});
                FeignExceptionResult feignExceptionResult = (FeignExceptionResult)JsonUtils.toObject((String)res, FeignExceptionResult.class);
                errorContent = feignExceptionResult.getMsg();
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e);
            }
            return new FeignErrorException(Integer.valueOf(500), errorContent);
        }
    }
}

