/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.feign.configuration;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.feign.loadbalancer.VersionLoadBalancer;
import com.taotao.cloud.feign.loadbalancer.chooser.IRuleChooser;
import com.taotao.cloud.feign.loadbalancer.chooser.RoundRuleChooser;
import com.taotao.cloud.feign.properties.LoadbalancerProperties;
import java.lang.reflect.InvocationTargetException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

@AutoConfiguration
@LoadBalancerClients(defaultConfiguration={VersionLoadBalancerClients.class})
@ConditionalOnProperty(prefix="taotao.cloud.feign.loadbalancer.isolation", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Import(value={VersionLoadbalancerRegisterBeanPostProcessor.class})
public class VersionLoadbalancerAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(VersionLoadbalancerAutoConfiguration.class, (String)"taotao-cloud-starter-feign", (String[])new String[0]);
    }

    public static class VersionLoadBalancerClients {
        @Autowired
        private LoadbalancerProperties properties;

        @Bean
        @ConditionalOnMissingBean(value={IRuleChooser.class})
        @ConditionalOnProperty(prefix="taotao.cloud.feign.loadbalancer.isolation", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public IRuleChooser ruleChooser(ApplicationContext context) {
            IRuleChooser chooser = new RoundRuleChooser();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.properties.getChooser())) {
                try {
                    Class ruleClass = ClassUtils.forName((String)this.properties.getChooser(), (ClassLoader)context.getClassLoader());
                    chooser = (IRuleChooser)ruleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    LogUtils.error((String)"\u6ca1\u6709\u627e\u5230\u5b9a\u4e49\u7684\u9009\u62e9\u5668\uff0c\u5c06\u4f7f\u7528\u5185\u7f6e\u7684\u9009\u62e9\u5668", (Object[])new Object[]{e});
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LogUtils.error((String)"\u6ca1\u6cd5\u521b\u5efa\u5b9a\u4e49\u7684\u9009\u62e9\u5668\uff0c\u5c06\u4f7f\u7528\u5185\u7f6e\u7684\u9009\u62e9\u5668", (Object[])new Object[]{e});
                }
            }
            return chooser;
        }

        @Bean
        @ConditionalOnMissingBean
        public IRuleChooser defaultRuleChooser() {
            return new RoundRuleChooser();
        }

        @Bean
        @ConditionalOnProperty(prefix="taotao.cloud.feign.loadbalancer", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public ReactorServiceInstanceLoadBalancer versionServiceLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, IRuleChooser ruleChooser) {
            String name = environment.getProperty("loadbalancer.client.name");
            return new VersionLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name, ruleChooser);
        }
    }

    public static class VersionLoadbalancerRegisterBeanPostProcessor
    implements BeanPostProcessor {
        @Autowired
        private LoadbalancerProperties properties;

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof NacosDiscoveryProperties && StringUtils.isNotBlank((String)this.properties.getVersion())) {
                NacosDiscoveryProperties nacosDiscoveryProperties = (NacosDiscoveryProperties)bean;
                nacosDiscoveryProperties.getMetadata().putIfAbsent("version", this.properties.getVersion());
            }
            return bean;
        }
    }
}

