/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.feign.formatter;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.openfeign.FeignFormatterRegistrar;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;

public class DateFormatRegister
implements FeignFormatterRegistrar {
    public void registerFormatters(FormatterRegistry registry) {
        registry.addConverter(Date.class, String.class, (Converter)new Date2StringConverter());
        registry.addConverter(LocalDateTime.class, String.class, (Converter)new LocalDateTime2StringConverter());
        registry.addConverter(LocalDate.class, String.class, (Converter)new LocalDate2StringConverter());
        registry.addConverter(LocalTime.class, String.class, (Converter)new LocalTime2StringConverter());
    }

    private static class Date2StringConverter
    implements Converter<Date, String> {
        private Date2StringConverter() {
        }

        public String convert(@NotNull Date source) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(source);
        }
    }

    private static class LocalDateTime2StringConverter
    implements Converter<LocalDateTime, String> {
        private LocalDateTime2StringConverter() {
        }

        public String convert(LocalDateTime source) {
            return source.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
    }

    private static class LocalDate2StringConverter
    implements Converter<LocalDate, String> {
        private LocalDate2StringConverter() {
        }

        public String convert(LocalDate source) {
            return source.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
    }

    private static class LocalTime2StringConverter
    implements Converter<LocalTime, String> {
        private LocalTime2StringConverter() {
        }

        public String convert(LocalTime source) {
            return source.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
    }
}

