/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.feign.http;

import cn.hutool.core.util.ObjectUtil;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.feign.configuration.FeignInterceptorAutoConfiguration;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RestTemplateHeaderInterceptor
implements ClientHttpRequestInterceptor {
    public ClientHttpResponse intercept(HttpRequest request, byte[] bytes, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders httpHeaders = request.getHeaders();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            FeignInterceptorAutoConfiguration.HEADER_NAME_LIST.forEach(headerName -> {});
            return execution.execute(request, bytes);
        }
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        if (httpServletRequest == null) {
            LogUtils.warn((String)"path={}, \u5728FeignClient API\u63a5\u53e3\u672a\u914d\u7f6eFeignConfiguration\u7c7b\uff0c \u6545\u800c\u65e0\u6cd5\u5728\u8fdc\u7a0b\u8c03\u7528\u65f6\u83b7\u53d6\u8bf7\u6c42\u5934\u4e2d\u7684\u53c2\u6570!", (Object[])new Object[]{request.getURI()});
            return execution.execute(request, bytes);
        }
        FeignInterceptorAutoConfiguration.HEADER_NAME_LIST.forEach(headerName -> {
            if (ObjectUtil.isNotEmpty((Object)httpServletRequest.getHeader(headerName))) {
                httpHeaders.add(headerName, httpServletRequest.getHeader(headerName));
            }
        });
        return execution.execute(request, bytes);
    }
}

