/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.feign.loadbalancer;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.feign.loadbalancer.chooser.IRuleChooser;
import com.taotao.cloud.feign.utils.QueryUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

public class VersionLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final String KEY_DEFAULT = "default";
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSuppliers;
    private final String serviceId;
    private final IRuleChooser ruleChooser;

    public VersionLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSuppliers, String serviceId, IRuleChooser ruleChooser) {
        this.serviceInstanceListSuppliers = serviceInstanceListSuppliers;
        this.serviceId = serviceId;
        this.ruleChooser = ruleChooser;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        RequestData requestData = ((RequestDataContext)request.getContext()).getClientRequest();
        String version = this.getVersionFromRequestData(requestData);
        LogUtils.debug((String)"\u9009\u62e9\u7684\u7248\u672c\u53f7\u4e3a\uff1a{}", (Object[])new Object[]{version});
        return ((ServiceInstanceListSupplier)this.serviceInstanceListSuppliers.getIfAvailable()).get(request).next().map(instanceList -> this.getInstanceResponse((List<ServiceInstance>)instanceList, version));
    }

    private String getVersionFromRequestData(RequestData requestData) {
        Map<String, String> queryMap = QueryUtils.getQueryMap(requestData.getUrl());
        if (MapUtils.isNotEmpty(queryMap) && queryMap.containsKey("taotao-cloud-request-version") && StringUtils.isNotBlank((CharSequence)queryMap.get("taotao-cloud-request-version"))) {
            return queryMap.get("taotao-cloud-request-version");
        }
        if (requestData.getHeaders().containsKey((Object)"taotao-cloud-request-version")) {
            return (String)requestData.getHeaders().get((Object)"taotao-cloud-request-version").get(0);
        }
        return null;
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> instances, String version) {
        ServiceInstance serviceInstance;
        List<Object> filteredServiceIstanceList = instances;
        if (StringUtils.isNotBlank((CharSequence)version) && CollectionUtils.isNotEmpty(instances)) {
            filteredServiceIstanceList = instances.stream().filter(item -> item.getMetadata().containsKey("version") && version.equals(item.getMetadata().get("version"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(filteredServiceIstanceList)) {
            filteredServiceIstanceList = instances.stream().filter(item -> !item.getMetadata().containsKey("version") || StringUtils.isBlank((CharSequence)((CharSequence)item.getMetadata().get("version"))) || KEY_DEFAULT.equals(item.getMetadata().get("version"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(filteredServiceIstanceList) && !Objects.isNull(serviceInstance = this.ruleChooser.choose(filteredServiceIstanceList))) {
            LogUtils.debug((String)"\u4f7f\u7528serviceId\u4e3a\uff1a{}\u670d\u52a1\uff0c \u9009\u62e9version\u4e3a\uff1a{}\uff0c \u5730\u5740\uff1a{}:{}\uff0c", (Object[])new Object[]{this.serviceId, version, serviceInstance.getHost(), serviceInstance.getPort()});
            return new DefaultResponse(serviceInstance);
        }
        return new EmptyResponse();
    }
}

