/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.idempotent.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.idempotent.aop.IdempotentAspect;
import com.taotao.cloud.idempotent.properties.IdempotentProperties;
import com.taotao.cloud.lock.support.DistributedLock;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={IdempotentProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.idempotent", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class IdempotentAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(IdempotentAutoConfiguration.class, (String)"taotao-cloud-starter-idempotent", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnBean
    public IdempotentAspect idempotentAspect(DistributedLock distributedLock) {
        return new IdempotentAspect(distributedLock);
    }
}

