/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.ip2region.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.ip2region.impl.Ip2regionSearcherImpl;
import com.taotao.cloud.ip2region.model.Ip2regionSearcher;
import com.taotao.cloud.ip2region.properties.Ip2regionProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ResourceLoader;

@AutoConfiguration
@EnableConfigurationProperties(value={Ip2regionProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.ip2region", name={"enabled"}, havingValue="true")
public class Ip2regionAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(Ip2regionAutoConfiguration.class, (String)"taotao-cloud-starter-ip2region", (String[])new String[0]);
    }

    @Bean
    public Ip2regionSearcher ip2regionSearcher(ResourceLoader resourceLoader, Ip2regionProperties properties) {
        return new Ip2regionSearcherImpl(resourceLoader, properties);
    }
}

