/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.ip2region.impl;

import com.taotao.cloud.ip2region.model.Ip2regionSearcher;
import com.taotao.cloud.ip2region.model.IpInfo;
import com.taotao.cloud.ip2region.model.Searcher;
import com.taotao.cloud.ip2region.properties.Ip2regionProperties;
import com.taotao.cloud.ip2region.utils.IpInfoUtil;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StreamUtils;

public class Ip2regionSearcherImpl
implements InitializingBean,
DisposableBean,
Ip2regionSearcher {
    private final ResourceLoader resourceLoader;
    private final Ip2regionProperties properties;
    private Searcher searcher;

    public Ip2regionSearcherImpl(ResourceLoader resourceLoader, Ip2regionProperties properties) {
        this.resourceLoader = resourceLoader;
        this.properties = properties;
    }

    @Override
    public IpInfo memorySearch(long ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.search(ip));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IpInfo memorySearch(String ip) {
        try {
            return IpInfoUtil.toIpInfo(this.searcher.search(ip));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Resource resource = this.resourceLoader.getResource(this.properties.getDbFileLocation());
        try (InputStream inputStream = resource.getInputStream();){
            this.searcher = Searcher.newWithBuffer(StreamUtils.copyToByteArray((InputStream)inputStream));
        }
    }

    public void destroy() throws Exception {
        if (this.searcher != null) {
            this.searcher.close();
        }
    }
}

