/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.quartz.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.quartz.QuartzDataSource;
import org.springframework.boot.autoconfigure.quartz.QuartzTransactionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionManager;

@Configuration
public class QuartzJobDataSourceAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(QuartzJobDataSourceAutoConfiguration.class, (String)"taotao-cloud-starter-job-quartz", (String[])new String[0]);
    }

    @Bean
    @QuartzDataSource
    public DataSource quartzDataSource() {
        HikariDataSource hikariDataSource = new HikariDataSource();
        hikariDataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        hikariDataSource.setUsername("root");
        hikariDataSource.setPassword("123456");
        hikariDataSource.setJdbcUrl("jdbc:mysql://192.168.253.202:3306/db_quartz?useUnicode=true&characterEncoding=utf8&zeroDateTimeBehavior=convertToNull&useSSL=false&serverTimezone=GMT%2B8&allowPublicKeyRetrieval=true");
        return hikariDataSource;
    }

    @Bean
    @QuartzTransactionManager
    public TransactionManager quartzTransactionManager(@Qualifier(value="quartzDataSource") DataSource quartzDataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(quartzDataSource);
        return transactionManager;
    }
}

