/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.quartz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.taotao.cloud.common.model.PageResult;
import com.taotao.cloud.job.quartz.dao.QuartzJobMapper;
import com.taotao.cloud.job.quartz.entity.QuartzJob;
import com.taotao.cloud.job.quartz.exception.QuartzExecutionException;
import com.taotao.cloud.job.quartz.param.QuartzJobDTO;
import com.taotao.cloud.job.quartz.param.QuartzJobQuery;
import com.taotao.cloud.job.quartz.service.QuartzJobService;
import com.taotao.cloud.job.quartz.utils.QuartzManager;
import com.taotao.cloud.job.quartz.vo.QuartzJobVO;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuartzJobServiceImpl
implements QuartzJobService {
    private final QuartzJobMapper quartzJobMapper;
    private final QuartzManager quartzManager;

    public QuartzJobServiceImpl(QuartzJobMapper quartzJobMapper, QuartzManager quartzManager) {
        this.quartzJobMapper = quartzJobMapper;
        this.quartzManager = quartzManager;
    }

    @PostConstruct
    public void init() throws SchedulerException {
        this.quartzManager.clear();
        List quartzJobList = this.quartzJobMapper.selectList(null);
        for (QuartzJob quartzJob : quartzJobList) {
            this.quartzManager.addJob(quartzJob);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addJob(QuartzJobDTO quartzJobDTO) {
        QuartzJob quartzJob = new QuartzJob();
        BeanUtil.copyProperties((Object)quartzJobDTO, (Object)quartzJob, (String[])new String[0]);
        quartzJob.setState(0);
        if (this.quartzJobMapper.insert(quartzJob) > 0) {
            this.quartzManager.addJob(quartzJob);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateJob(QuartzJobDTO quartzJobDTO) {
        QuartzJob quartzJob = (QuartzJob)this.quartzJobMapper.selectById(quartzJobDTO.getId());
        BeanUtil.copyProperties((Object)quartzJobDTO, (Object)quartzJob, (CopyOptions)CopyOptions.create().ignoreNullValue());
        this.quartzJobMapper.updateById(quartzJob);
        this.quartzManager.updateJob(quartzJob);
    }

    @Override
    public void runOnce(Long id) {
        QuartzJob quartzJob = (QuartzJob)this.quartzJobMapper.selectById(id);
        this.quartzManager.runJobNow(quartzJob);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void start(Long id) {
        QuartzJob quartzJob = (QuartzJob)this.quartzJobMapper.selectById(id);
        if (Objects.equals(quartzJob.getState(), 1)) {
            throw new QuartzExecutionException("\u5df2\u7ecf\u662f\u542f\u52a8\u72b6\u6001");
        }
        quartzJob.setState(1);
        this.quartzJobMapper.updateById(quartzJob);
        this.quartzManager.addJob(quartzJob);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void stopJob(Long id) {
        QuartzJob quartzJob = (QuartzJob)this.quartzJobMapper.selectById(id);
        if (Objects.equals(quartzJob.getState(), 0)) {
            throw new QuartzExecutionException("\u5df2\u7ecf\u662f\u505c\u6b62\u72b6\u6001");
        }
        quartzJob.setState(0);
        this.quartzJobMapper.updateById(quartzJob);
        this.quartzManager.pauseJob(quartzJob);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteJob(Long id) {
        QuartzJob quartzJob = (QuartzJob)this.quartzJobMapper.selectById(id);
        this.quartzJobMapper.deleteById(id);
        this.quartzManager.deleteJob(quartzJob);
    }

    @Override
    public void syncJobStatus() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(QuartzJob::getState, (Object)1);
        List quartzJobs = this.quartzJobMapper.selectList((Wrapper)wrapper);
        Map<String, QuartzJob> quartzJobMap = quartzJobs.stream().collect(Collectors.toMap(o -> o.getId().toString(), o -> o));
        List<Trigger> triggers = this.quartzManager.findTriggers();
        for (Trigger trigger : triggers) {
            String triggerName = trigger.getKey().getName();
            if (!quartzJobMap.containsKey(triggerName)) {
                this.quartzManager.deleteTrigger(triggerName);
                continue;
            }
            quartzJobMap.remove(triggerName);
        }
        Collection<QuartzJob> quartzJobList = quartzJobMap.values();
        for (QuartzJob quartzJob : quartzJobList) {
            quartzJob.setState(0);
        }
        if (CollUtil.isNotEmpty(quartzJobList)) {
            quartzJobList.forEach(arg_0 -> ((QuartzJobMapper)this.quartzJobMapper).updateById(arg_0));
        }
    }

    @Override
    public void startAllJobs() {
        this.quartzManager.startAllJobs();
    }

    @Override
    public void pauseAllJobs() {
        this.quartzManager.pauseAll();
    }

    @Override
    public void resumeAllJobs() {
        this.quartzManager.resumeAll();
    }

    @Override
    public void shutdownAllJobs() {
        this.quartzManager.shutdownAll();
    }

    @Override
    public QuartzJob findById(Long id) {
        return (QuartzJob)this.quartzJobMapper.selectById(id);
    }

    @Override
    public PageResult<QuartzJobVO> page(QuartzJobQuery quartzJobQuery) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.orderByDesc(QuartzJob::getId);
        IPage quartzJobIPage = this.quartzJobMapper.selectPage(quartzJobQuery.buildMpPage(), (Wrapper)wrapper);
        return PageResult.convertMybatisPage((IPage)quartzJobIPage, QuartzJobVO.class);
    }

    @Override
    public String judgeJobClass(String jobClassName) {
        return this.quartzManager.getJobClass(jobClassName).getName();
    }
}

