/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.quartz.configuration;

import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.job.quartz.event.DefaultQuartzEventListener;
import com.taotao.cloud.job.quartz.event.RedisQuartzEventListener;
import com.taotao.cloud.job.quartz.listener.QuartzListenerRegister;
import com.taotao.cloud.job.quartz.properties.QuartzProperties;
import com.taotao.cloud.job.quartz.utils.QuartzManager;
import org.jetbrains.annotations.NotNull;
import org.quartz.Scheduler;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;
import org.springframework.stereotype.Component;

@AutoConfiguration
@ConditionalOnProperty(prefix="taotao.cloud.job.quartz", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={QuartzProperties.class})
public class QuartzJobAutoConfiguration
implements ApplicationContextAware,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(QuartzJobAutoConfiguration.class, (String)"taotao-cloud-starter-job-quartz", (String[])new String[0]);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ContextUtils.setApplicationContext((ConfigurableApplicationContext)((ConfigurableApplicationContext)applicationContext));
    }

    @Bean(name={"scheduler"})
    public Scheduler scheduler(SchedulerFactoryBean schedulerFactoryBean) throws Exception {
        Scheduler scheduler = schedulerFactoryBean.getScheduler();
        scheduler.start();
        return scheduler;
    }

    @Bean
    public QuartzManager quartzManage() {
        return new QuartzManager();
    }

    @Bean
    public QuartzListenerRegister quartzListenerRegister() {
        return new QuartzListenerRegister();
    }

    @Bean
    @ConditionalOnBean(value={RedisRepository.class})
    public RedisQuartzEventListener redisQuartzLogEventListener() {
        return new RedisQuartzEventListener();
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultQuartzEventListener defaultQuartzLogEventListener() {
        return new DefaultQuartzEventListener();
    }

    @Component(value="quartzJobFactory")
    public static class QuartzJobFactory
    extends SpringBeanJobFactory {
        private final AutowireCapableBeanFactory capableBeanFactory;

        public QuartzJobFactory(AutowireCapableBeanFactory capableBeanFactory) {
            this.capableBeanFactory = capableBeanFactory;
        }

        @NotNull
        protected Object createJobInstance(@NotNull TriggerFiredBundle bundle) throws Exception {
            Object jobInstance = super.createJobInstance(bundle);
            this.capableBeanFactory.autowireBean(jobInstance);
            return jobInstance;
        }
    }
}

