/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.quartz.controller;

import com.taotao.cloud.common.model.PageResult;
import com.taotao.cloud.common.model.Result;
import com.taotao.cloud.job.quartz.entity.QuartzJob;
import com.taotao.cloud.job.quartz.param.QuartzJobDTO;
import com.taotao.cloud.job.quartz.param.QuartzJobQuery;
import com.taotao.cloud.job.quartz.service.QuartzJobService;
import com.taotao.cloud.job.quartz.utils.CronUtils;
import com.taotao.cloud.job.quartz.vo.QuartzJobVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5b9a\u65f6\u4efb\u52a1")
@RestController
@RequestMapping(value={"/api/quartz"})
public class QuartzJobController {
    private final QuartzJobService quartzJobService;

    public QuartzJobController(QuartzJobService quartzJobService) {
        this.quartzJobService = quartzJobService;
    }

    @Operation(summary="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<Boolean> add(@RequestBody QuartzJobDTO quartzJobDTO) {
        if (!CronUtils.isValid(quartzJobDTO.getCronExpression())) {
            return Result.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0cCron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        this.quartzJobService.addJob(quartzJobDTO);
        return Result.success((Object)true);
    }

    @Operation(summary="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Boolean> update(@RequestBody QuartzJobDTO quartzJobDTO) {
        if (!CronUtils.isValid(quartzJobDTO.getCronExpression())) {
            return Result.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0cCron\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
        }
        this.quartzJobService.updateJob(quartzJobDTO);
        return Result.success((Object)true);
    }

    @Operation(summary="\u5206\u9875")
    @GetMapping(value={"/page"})
    public Result<PageResult<QuartzJobVO>> page(QuartzJobQuery quartzJobQuery) {
        return Result.success(this.quartzJobService.page(quartzJobQuery));
    }

    @Operation(summary="\u5355\u6761")
    @GetMapping(value={"/findById"})
    public Result<QuartzJobVO> findById(Long id) {
        QuartzJob quartzJob = this.quartzJobService.findById(id);
        return Result.success((Object)new QuartzJobVO());
    }

    @Operation(summary="\u542f\u52a8")
    @PostMapping(value={"/start"})
    public Result<Boolean> start(Long id) {
        this.quartzJobService.start(id);
        return Result.success((Object)true);
    }

    @Operation(summary="\u505c\u6b62")
    @PostMapping(value={"/stop"})
    public Result<Boolean> stop(Long id) {
        this.quartzJobService.stopJob(id);
        return Result.success((Object)true);
    }

    @Operation(summary="\u7acb\u5373\u6267\u884c")
    @PostMapping(value={"/execute"})
    public Result<Boolean> execute(Long id) {
        this.quartzJobService.runOnce(id);
        return Result.success((Object)true);
    }

    @Operation(summary="\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<Boolean> delete(Long id) {
        this.quartzJobService.deleteJob(id);
        return Result.success((Object)true);
    }

    @Operation(summary="\u5224\u65ad\u662f\u5426\u662f\u5b9a\u65f6\u4efb\u52a1\u7c7b")
    @GetMapping(value={"/judgeJobClass"})
    public Result<String> judgeJobClass(String jobClassName) {
        return Result.success((Object)this.quartzJobService.judgeJobClass(jobClassName));
    }

    @Operation(summary="\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u72b6\u6001")
    @PostMapping(value={"/syncJobStatus"})
    public Result<Boolean> syncJobStatus() {
        this.quartzJobService.syncJobStatus();
        return Result.success((Object)true);
    }
}

