/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.quartz.execution;

import com.google.common.base.Stopwatch;
import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.job.quartz.entity.QuartzJob;
import com.taotao.cloud.job.quartz.entity.QuartzJobLog;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractQuartzExecutionJob
extends QuartzJobBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext context) {
        QuartzJob quartzJob = (QuartzJob)context.getMergedJobDataMap().get((Object)"JOB_KEY");
        QuartzJobLog quartzJobLog = new QuartzJobLog();
        quartzJobLog.setJobName(quartzJob.getJobName());
        quartzJobLog.setBeanName(quartzJob.getBeanName());
        quartzJobLog.setMethodName(quartzJob.getMethodName());
        quartzJobLog.setParams(quartzJob.getParams());
        quartzJobLog.setCronExpression(quartzJob.getCronExpression());
        quartzJobLog.setExecutionThread(Thread.currentThread().getName());
        quartzJobLog.setStartTime(LocalDateTime.now());
        Stopwatch sw = Stopwatch.createStarted();
        try {
            LogUtils.info((String)"\u51c6\u5907\u6267\u884c\u4efb\u52a1\uff0c\u4efb\u52a1ID\uff1a{}", (Object[])new Object[]{quartzJob.getId()});
            this.doExecute(quartzJob);
            long seconds = sw.stop().elapsed(TimeUnit.SECONDS);
            quartzJobLog.setTime(seconds);
            quartzJobLog.setSuccess(true);
            quartzJobLog.setEndTime(LocalDateTime.now());
            LogUtils.info((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u4efb\u52a1\u540d\u79f0\uff1a{} \u603b\u5171\u8017\u65f6\uff1a{} \u79d2", (Object[])new Object[]{quartzJob.getJobName(), seconds});
        }
        catch (Exception e) {
            LogUtils.error((String)("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u540d\u79f0\uff1a{}" + quartzJob.getJobName()), (Object[])new Object[]{e});
            long seconds = sw.stop().elapsed(TimeUnit.SECONDS);
            quartzJobLog.setTime(seconds);
            quartzJobLog.setSuccess(false);
            quartzJobLog.setExceptionDetail(LogUtils.getStackTrace((Throwable)e));
            quartzJobLog.setEndTime(LocalDateTime.now());
        }
        LogUtils.info((String)quartzJobLog.toString(), (Object[])new Object[0]);
    }

    protected void doExecute(QuartzJob scheduleJob) throws Exception {
        String methodName = scheduleJob.getMethodName();
        String params = scheduleJob.getParams();
        Object target = ContextUtils.getBean((String)scheduleJob.getBeanName(), (boolean)true);
        if (Objects.isNull(target)) {
            throw new RuntimeException("\u672a\u627e\u5230bean");
        }
        Method method = StringUtils.isNotBlank((CharSequence)params) ? target.getClass().getDeclaredMethod(methodName, String.class) : target.getClass().getDeclaredMethod(methodName, new Class[0]);
        ReflectionUtils.makeAccessible((Method)method);
        if (StringUtils.isNotBlank((CharSequence)params)) {
            method.invoke(target, params);
        } else {
            method.invoke(target, new Object[0]);
        }
    }
}

