/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.quartz.listener;

import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.date.DateUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.job.quartz.entity.QuartzJob;
import com.taotao.cloud.job.quartz.entity.QuartzJobLog;
import com.taotao.cloud.job.quartz.event.QuartzEvent;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Objects;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.listeners.JobListenerSupport;
import org.springframework.context.ApplicationEvent;

public class QuartzJobListener
extends JobListenerSupport {
    public static final ThreadLocal<QuartzJobLog> QUARTZ_JOB_LOG_THREAD_LOCAL = new ThreadLocal();

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        String jobKey = context.getJobDetail().getKey().toString();
        LogUtils.info((String)"CustomJobListener \u5b9a\u65f6\u4efb\u52a1:{}-\u5f00\u59cb\u6267\u884c", (Object[])new Object[]{jobKey});
        QuartzJob quartzJob = (QuartzJob)context.getMergedJobDataMap().get((Object)"JOB_KEY");
        QuartzJobLog log = new QuartzJobLog();
        log.setJobName(quartzJob.getJobName());
        log.setBeanName(quartzJob.getBeanName());
        log.setMethodName(quartzJob.getMethodName());
        log.setParams(quartzJob.getParams());
        log.setCronExpression(quartzJob.getCronExpression());
        log.setStartTime(LocalDateTime.now());
        QUARTZ_JOB_LOG_THREAD_LOCAL.set(log);
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        LogUtils.info((String)"CustomJobListener \u5b9a\u65f6\u4efb\u52a1\u88ab\u5426\u51b3\u6267\u884c", (Object[])new Object[0]);
        super.jobExecutionVetoed(context);
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        String jobKey = context.getJobDetail().getKey().toString();
        LogUtils.info((String)"CustomJobListener \u5b9a\u65f6\u4efb\u52a1:{}-\u6267\u884c\u7ed3\u675f", (Object[])new Object[]{jobKey});
        QuartzJob quartzJob = (QuartzJob)context.getMergedJobDataMap().get((Object)"JOB_KEY");
        QuartzJobLog quartzJobLog = QUARTZ_JOB_LOG_THREAD_LOCAL.get();
        if (Objects.isNull(jobException)) {
            long times = DateUtils.getTimestamp() - Timestamp.valueOf(quartzJobLog.getStartTime()).getTime();
            quartzJobLog.setTime(times);
            quartzJobLog.setSuccess(true);
            LogUtils.info((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0c\u4efb\u52a1\u540d\u79f0\uff1a{} \u603b\u5171\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object[])new Object[]{quartzJob.getJobName(), times});
        } else {
            LogUtils.error((String)("\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u4efb\u52a1\u540d\u79f0\uff1a{}" + quartzJob.getJobName()), (Object[])new Object[]{jobException});
            long times = DateUtils.getTimestamp() - Timestamp.valueOf(quartzJobLog.getStartTime()).getTime();
            quartzJobLog.setTime(times);
            quartzJobLog.setSuccess(false);
            quartzJobLog.setExceptionDetail(LogUtils.getStackTrace((Throwable)jobException));
            quartzJob.setState(1);
        }
        QUARTZ_JOB_LOG_THREAD_LOCAL.remove();
        ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzJobLog));
    }
}

