/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.quartz.utils;

import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.job.quartz.entity.QuartzJob;
import com.taotao.cloud.job.quartz.enums.ScheduleConcurrentEnum;
import com.taotao.cloud.job.quartz.enums.ScheduleStatusEnum;
import com.taotao.cloud.job.quartz.event.QuartzEvent;
import com.taotao.cloud.job.quartz.exception.QuartzExecutionException;
import com.taotao.cloud.job.quartz.execution.ScheduleConcurrentExecution;
import com.taotao.cloud.job.quartz.execution.ScheduleDisallowConcurrentExecution;
import com.taotao.cloud.job.quartz.utils.CronUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.context.ApplicationEvent;

public class QuartzManager {
    private static final String JOB_NAME = "TASK_";
    private static final String TRIGGER_NAME = "TRIGGER_";
    @Resource(name="scheduler")
    private Scheduler scheduler;

    public void addJob(QuartzJob quartzJob) {
        try {
            JobKey jobKey = QuartzManager.getJobKey(quartzJob);
            JobDetail jobDetail = JobBuilder.newJob(QuartzManager.getJobClass(quartzJob)).withIdentity(jobKey).withDescription(quartzJob.getRemark()).storeDurably().build();
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)quartzJob.getCronExpression()).withMisfireHandlingInstructionDoNothing();
            TriggerKey triggerKey = QuartzManager.getTriggerKey(quartzJob);
            Trigger cronTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
            cronTrigger.getJobDataMap().put("JOB_KEY", (Object)quartzJob);
            ((CronTriggerImpl)cronTrigger).setStartTime(new Date());
            this.scheduler.scheduleJob(jobDetail, cronTrigger);
            if (this.scheduler.checkExists(jobKey)) {
                this.deleteJob(quartzJob);
            }
            if (CronUtils.getNextExecution(quartzJob.getCronExpression()) != null) {
                this.scheduler.scheduleJob(jobDetail, cronTrigger);
            }
            if (quartzJob.getState().equals(ScheduleStatusEnum.PAUSE.getValue())) {
                this.pauseJob(quartzJob);
            }
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzJob));
            LogUtils.info((String)"\u6dfb\u52a0Quartz\u5b9a\u65f6\u4efb\u52a1\u6210\u529f", (Object[])new Object[0]);
        }
        catch (Exception e) {
            LogUtils.error((String)"\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void updateJob(QuartzJob quartzJob) {
        try {
            if (this.checkExists(quartzJob)) {
                this.deleteJob(quartzJob);
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
        this.addJob(quartzJob);
    }

    public boolean checkExists(QuartzJob quartzJob) throws SchedulerException {
        return this.scheduler.checkExists(QuartzManager.getJobKey(quartzJob));
    }

    public void deleteJob(QuartzJob quartzJob) {
        try {
            this.scheduler.pauseJob(QuartzManager.getJobKey(quartzJob));
            this.scheduler.deleteJob(QuartzManager.getJobKey(quartzJob));
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzJob));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void resumeJob(QuartzJob quartzJob) {
        try {
            this.scheduler.resumeJob(QuartzManager.getJobKey(quartzJob));
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzJob));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void runJobNow(QuartzJob quartzJob) {
        try {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("JOB_KEY", (Object)quartzJob);
            if (this.checkExists(quartzJob)) {
                this.scheduler.triggerJob(QuartzManager.getJobKey(quartzJob), dataMap);
            }
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzJob));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25");
        }
    }

    public void pauseJob(QuartzJob quartzJob) {
        try {
            this.scheduler.pauseJob(QuartzManager.getJobKey(quartzJob));
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzJob));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5b9a\u65f6\u4efb\u52a1\u6682\u505c\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u5b9a\u65f6\u4efb\u52a1\u6682\u505c\u5931\u8d25");
        }
    }

    public Class<? extends Job> getJobClass(String classname) {
        Class<?> clazz;
        try {
            clazz = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new QuartzExecutionException("\u627e\u4e0d\u5230\u8be5\u5b9a\u65f6\u4efb\u52a1\u7c7b\u540d");
        }
        if (Job.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new QuartzExecutionException("\u8be5\u7c7b\u4e0d\u662f\u5b9a\u65f6\u4efb\u52a1\u7c7b");
    }

    public static Class<? extends Job> getJobClass(QuartzJob quartzJob) {
        if (quartzJob.getConcurrent().equals(ScheduleConcurrentEnum.NO.getValue())) {
            return ScheduleDisallowConcurrentExecution.class;
        }
        return ScheduleConcurrentExecution.class;
    }

    public static TriggerKey getTriggerKey(QuartzJob quartzJob) {
        return TriggerKey.triggerKey((String)(TRIGGER_NAME + quartzJob.getId()), (String)quartzJob.getGroupName());
    }

    public static JobKey getJobKey(QuartzJob quartzJob) {
        return JobKey.jobKey((String)(JOB_NAME + quartzJob.getId()), (String)quartzJob.getGroupName());
    }

    public void startAllJobs() {
        try {
            this.scheduler.start();
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5f00\u542f\u6240\u6709\u7684\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
        }
    }

    public void pauseAll() {
        try {
            this.scheduler.pauseAll();
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6682\u505c\u6240\u6709\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
        }
    }

    public void resumeAll() {
        try {
            this.scheduler.resumeAll();
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6062\u590d\u6240\u6709\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
        }
    }

    public void shutdownAll() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown(true);
            }
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5173\u95ed\u6240\u6709\u7684\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
        }
    }

    public List<Trigger> findTriggers() {
        try {
            GroupMatcher matcher = GroupMatcher.anyJobGroup();
            Set jobKeys = this.scheduler.getJobKeys(matcher);
            return jobKeys.stream().map(this::getTriggersOfJob).flatMap(Collection::stream).collect(Collectors.toList());
        }
        catch (SchedulerException e) {
            LogUtils.error((Throwable)e);
            throw new QuartzExecutionException(e.getMessage());
        }
    }

    private List<? extends Trigger> getTriggersOfJob(JobKey jobKey) {
        try {
            return this.scheduler.getTriggersOfJob(jobKey);
        }
        catch (SchedulerException e) {
            LogUtils.error((Throwable)e);
            throw new QuartzExecutionException(e);
        }
    }

    public void deleteTrigger(String triggerName) {
        try {
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)triggerName));
        }
        catch (SchedulerException e) {
            LogUtils.error((Throwable)e);
        }
    }

    public void clear() {
        try {
            this.scheduler.clear();
        }
        catch (SchedulerException e) {
            LogUtils.error((Throwable)e);
        }
    }
}

