/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.schedule.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.redis.spring.RedisLockProvider;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@AutoConfiguration
@EnableSchedulerLock(defaultLockAtMostFor="PT55S")
public class ShedLockRedisAutoConfiguration
implements InitializingBean {
    @Value(value="${spring.profiles.active}")
    private String env;
    @Value(value="${server.port}")
    private String port;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ShedLockRedisAutoConfiguration.class, (String)"taotao-cloud-starter-job-schedule", (String[])new String[0]);
    }

    @Bean
    public LockProvider lockProvider(RedisConnectionFactory connectionFactory) {
        return new RedisLockProvider(connectionFactory, this.env);
    }
}

