/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.schedule.controller;

import com.taotao.cloud.job.schedule.model.param.TaskParam;
import com.taotao.cloud.job.schedule.model.vo.TaskVo;
import com.taotao.cloud.job.schedule.service.TaskService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="task")
@Tag(name="\u4efb\u52a1\u7ba1\u7406")
public class TaskController {
    @Resource
    private TaskService taskService;

    @GetMapping(value={"/list"})
    @Operation(summary="\u4efb\u52a1\u5217\u8868")
    public Object taskList() {
        return this.taskService.taskList();
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u65b0\u589e\u4efb\u52a1")
    public void addTask(@RequestBody TaskParam param) {
        this.taskService.addTask(param);
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u66f4\u65b0\u4efb\u52a1")
    public void updateTask(@RequestBody TaskParam param) {
        this.taskService.updateTask(param);
    }

    @DeleteMapping(value={"delete/{id}"})
    @Operation(summary="\u5220\u9664\u4efb\u52a1")
    public void deleteTask(@PathVariable(value="id") String id) {
        this.taskService.deleteTask(id);
    }

    @PostMapping(value={"stop/{id}"})
    @Operation(summary="\u6682\u505c\u4efb\u52a1")
    public void stopTask(@PathVariable(value="id") String id) {
        this.taskService.stopTask(id);
    }

    @PostMapping(value={"invoke/{id}"})
    @Operation(summary="\u6267\u884c\u4efb\u52a1")
    public void invokeTask(@PathVariable(value="id") String id) {
        this.taskService.invokeTask(id);
    }

    @GetMapping(value={"info/{id}"})
    @Operation(summary="\u67e5\u8be2\u8be6\u60c5")
    public TaskVo getTaskById(@PathVariable(value="id") String id) {
        return this.taskService.getTaskById(id);
    }
}

