/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.schedule.service;

import com.taotao.cloud.job.schedule.model.entity.Task;
import com.taotao.cloud.job.schedule.model.entity.TaskLog;
import com.taotao.cloud.job.schedule.model.param.TaskParam;
import com.taotao.cloud.job.schedule.model.vo.TaskVo;
import com.taotao.cloud.job.schedule.service.TaskService;
import com.taotao.cloud.job.schedule.task.TaskManager;
import com.taotao.cloud.job.schedule.task.TaskMapper;
import com.taotao.cloud.job.schedule.utils.CronUtils;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
implements TaskService {
    @Resource
    private TaskMapper taskMapper;
    @Resource
    private TaskManager taskManager;

    @Override
    public Object taskList() {
        return this.taskMapper.taskList();
    }

    @Override
    public void addTask(TaskParam param) {
        String cron = CronUtils.dateConvertToCron(param);
        Date nextTime = CronUtils.nextCurrentTime(cron);
        Task task = new Task();
        BeanUtils.copyProperties((Object)param, (Object)task);
        task.setId(UUID.randomUUID().toString());
        task.setDelFlag(0);
        task.setCronExpression(cron);
        task.setNextRunTime(nextTime);
        Integer situation = param.getPolicy() == 1 ? 2 : 1;
        task.setSituation(situation);
        task.setVersion(0);
        task.setStatus(0);
        task.setCreateBy("");
        task.setCreateTime(new Date());
        task.setUpdateBy("");
        task.setUpdateTime(new Date());
        this.taskMapper.insert(task);
        String runType = param.getPolicy() == 1 ? "user" : "sys";
        this.taskManager.start(task, runType);
    }

    @Override
    public void updateTask(TaskParam param) {
        Task task = this.taskMapper.selectTaskById(param.getId());
        if (task == null) {
            throw new RuntimeException("\u66f4\u65b0\u5931\u8d25,\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        String cron = CronUtils.dateConvertToCron(param);
        Date nextTime = CronUtils.nextCurrentTime(cron);
        BeanUtils.copyProperties((Object)param, (Object)task);
        task.setCronExpression(cron);
        task.setNextRunTime(nextTime);
        int situation = param.getPolicy() == 1 ? 2 : 1;
        task.setSituation(situation);
        task.setStatus(0);
        task.setUpdateBy("");
        task.setUpdateTime(new Date());
        this.taskMapper.update(task);
        String runType = param.getPolicy() == 1 ? "user" : "sys";
        this.taskManager.start(task, runType);
    }

    @Override
    public void invokeTask(String id) {
        Task task = this.taskMapper.selectTaskById(id);
        if (task == null) {
            throw new RuntimeException("\u6267\u884c\u5931\u8d25,\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        this.taskManager.start(task, "sys");
    }

    @Override
    public void stopTask(String id) {
        Task task = this.taskMapper.selectTaskById(id);
        if (task == null) {
            throw new RuntimeException("\u6682\u505c\u4efb\u52a1\u5931\u8d25,\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        this.taskManager.stop(id);
    }

    @Override
    public void deleteTask(String id) {
        Task task = this.taskMapper.selectTaskById(id);
        if (task == null) {
            throw new RuntimeException("\u5220\u9664\u4efb\u52a1\u5931\u8d25,\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        this.taskManager.stop(id);
        this.taskMapper.deleteTask(id);
    }

    @Override
    public void forbidTask(String id) {
        Task task = this.taskMapper.selectTaskById(id);
        if (task == null) {
            throw new RuntimeException("\u7981\u7528\u5931\u8d25,\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        this.taskManager.stop(id);
        task.setStatus(1);
        this.taskMapper.update(task);
    }

    @Override
    public TaskVo getTaskById(String id) {
        Task task = this.taskMapper.selectTaskById(id);
        TaskVo taskVo = new TaskVo();
        BeanUtils.copyProperties((Object)task, (Object)taskVo);
        List nextExecution = (List)CronUtils.getNextExecution(task.getCronExpression(), 8, true);
        taskVo.setNext(nextExecution);
        return taskVo;
    }

    @Override
    @Async
    public void insertTaskLog(TaskLog log) {
        this.taskMapper.insertTaskLog(log);
    }
}

