/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.schedule.task;

import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.job.schedule.model.entity.Task;
import com.taotao.cloud.job.schedule.task.TaskLogRecord;
import com.taotao.cloud.job.schedule.task.TaskManager;
import com.taotao.cloud.job.schedule.task.TaskMapper;
import com.taotao.cloud.job.schedule.utils.CronUtils;
import com.taotao.cloud.job.schedule.utils.JobInvokeUtil;
import com.taotao.cloud.lock.support.DistributedLock;
import com.taotao.cloud.lock.support.ZLock;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunnable
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private final String id;
    public static final String TASK_LOCK_KEY = "task_lock_key:";
    private boolean checkTime = false;

    public TaskRunnable(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block16: {
            DistributedLock distributedLock = (DistributedLock)ContextUtils.getBean(DistributedLock.class);
            if (distributedLock == null) {
                LogUtils.warn((String)"\u5206\u5e03\u5f0f\u9501\u4e3a\u7a7a, \u4e0d\u652f\u6301\u5206\u5e03\u5f0f, \u8bf7\u914d\u7f6etaotao.cloud.lock.type=redis", (Object[])new Object[0]);
            }
            String value = UUID.randomUUID().toString();
            long currentTime = System.currentTimeMillis();
            Task currentTask = ((TaskMapper)ContextUtils.getBean(TaskMapper.class)).selectTaskById(this.id);
            ZLock zLock = null;
            Date nextRunTime = currentTask.getNextRunTime();
            this.log.info("\u4efb\u52a1\uff1a{}\uff0c\u5f53\u524d\uff1a{}\uff0c\u4e0b\u6b21\uff1a{}", new Object[]{this.id, new Date(), nextRunTime});
            long diffTime = Math.abs(currentTime - nextRunTime.getTime());
            String lockKey = TASK_LOCK_KEY + this.id;
            try {
                zLock = diffTime <= 1000L ? distributedLock.lock(lockKey, 500L, TimeUnit.MILLISECONDS) : distributedLock.lock(lockKey, 1L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e);
            }
            if (zLock == null) {
                this.log.info("\u4efb\u52a1:{} \u5df2\u6267\u884c\uff0c\u6682\u505c\u5f53\u524d\u6267\u884c!", (Object)this.id);
            } else {
                if (diffTime > 200L && this.checkTime) {
                    String msg = "\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u65f6\u95f4\u8282\u70b9\u9519\u8bef\uff01";
                    this.log.error(msg);
                    throw new RuntimeException(msg);
                }
                String invokeTarget = currentTask.getInvokeTarget();
                String beanName = JobInvokeUtil.getBeanName(invokeTarget);
                String methodName = JobInvokeUtil.getMethodName(invokeTarget);
                List<Object[]> methodParams = JobInvokeUtil.getMethodParams(invokeTarget);
                methodParams.add(0, new Object[]{this.id, String.class});
                Object bean = ContextUtils.getBean((String)beanName);
                Method method = bean.getClass().getDeclaredMethod(methodName, JobInvokeUtil.getMethodParamsType(methodParams));
                long startTime = System.currentTimeMillis();
                method.invoke(bean, JobInvokeUtil.getMethodParamsValue(methodParams));
                this.updateTask(currentTask);
                TaskLogRecord.recordTaskLog(this.id, startTime, null);
            }
            this.checkTime = true;
            try {
                distributedLock.unlock(zLock);
            }
            catch (Exception e) {
                LogUtils.error((String)"\u6bcf\u5206\u949f\u4efb\u52a1\u5f02\u5e38", (Object[])new Object[]{e});
            }
            break block16;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    this.updateTask(currentTask);
                    TaskLogRecord.recordTaskLog(this.id, 0L, e);
                    this.checkTime = true;
                }
                catch (Throwable throwable) {
                    this.checkTime = true;
                    try {
                        distributedLock.unlock(zLock);
                    }
                    catch (Exception e2) {
                        LogUtils.error((String)"\u6bcf\u5206\u949f\u4efb\u52a1\u5f02\u5e38", (Object[])new Object[]{e2});
                    }
                    throw throwable;
                }
                try {
                    distributedLock.unlock(zLock);
                }
                catch (Exception e3) {
                    LogUtils.error((String)"\u6bcf\u5206\u949f\u4efb\u52a1\u5f02\u5e38", (Object[])new Object[]{e3});
                }
            }
        }
    }

    private void updateTask(Task currentTask) {
        String taskId = currentTask.getId();
        TaskManager taskManager = (TaskManager)ContextUtils.getBean(TaskManager.class);
        if (taskManager.getTaskMap().get(taskId) != null) {
            String cron = currentTask.getCronExpression();
            String invokeTarget = currentTask.getInvokeTarget();
            Date nextRunTime = currentTask.getNextRunTime();
            Date nextTime = CronUtils.nextCurrentTime(cron);
            Task task = new Task();
            task.setId(taskId);
            task.setCronExpression(cron);
            task.setInvokeTarget(invokeTarget);
            task.setLastRunTime(nextRunTime);
            task.setNextRunTime(nextTime);
            task.setSituation(1);
            ((TaskMapper)ContextUtils.getBean(TaskMapper.class)).update(task);
            this.log.info("\u66f4\u65b0\u4efb\u52a1\u6267\u884c\u60c5\u51b5!");
        }
    }
}

