/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.schedule.utils;

import com.taotao.cloud.job.schedule.model.param.TaskParam;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.CronExpression;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CronUtils {
    private static boolean isValid(String cronExpression) {
        return CronExpression.isValidExpression((String)cronExpression);
    }

    public static Object getNextExecution(String cronExpression, int num, boolean format) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cronExpression);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)num);
            if (!format) {
                return dates;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (Date date : dates) {
                list.add(dateFormat.format(date));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String dateConvertToCron(TaskParam param) {
        String finalWeek = "?";
        String finalMonth = "*";
        String finalDay = "*";
        String finalHour = "*";
        String finalMinute = "*";
        String finalSecods = "*";
        switch (param.getCycle()) {
            case "week": {
                String[] split = param.getWeek().split(",");
                ArrayList<Object> newWeek = new ArrayList<Object>();
                for (String s : split) {
                    if ("7".equals(s)) {
                        newWeek.add("6");
                        continue;
                    }
                    newWeek.add("" + (Integer.valueOf(s) + 1));
                }
                finalWeek = String.join((CharSequence)",", newWeek);
                finalMonth = "*";
                finalDay = "?";
                finalHour = param.getHour();
                finalMinute = param.getMinute();
                finalSecods = param.getSecods();
                break;
            }
            case "month": {
                finalMonth = param.getMonth();
                finalDay = param.getDay();
                finalHour = param.getHour();
                finalMinute = param.getMinute();
                finalSecods = param.getSecods();
                break;
            }
            case "day": {
                finalDay = param.getDay();
                finalHour = param.getHour();
                finalMinute = param.getMinute();
                finalSecods = param.getSecods();
                break;
            }
            case "hour": {
                finalHour = param.getHour();
                finalMinute = param.getMinute();
                finalSecods = param.getSecods();
                break;
            }
            case "minute": {
                finalMinute = param.getMinute();
                finalSecods = param.getSecods();
                break;
            }
            case "secods": {
                finalSecods = param.getSecods();
                break;
            }
            default: {
                throw new RuntimeException("\u5468\u671f\u89e3\u6790\u51fa\u9519!");
            }
        }
        String cron = finalSecods + " " + finalMinute + " " + finalHour + " " + finalDay + " " + finalMonth + " " + finalWeek;
        if (!CronUtils.isValid(cron)) {
            throw new RuntimeException("\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519!");
        }
        return cron;
    }

    public static Date nextCurrentTime(String cron) {
        List execution = (List)CronUtils.getNextExecution(cron, 2, false);
        long timeMillis = System.currentTimeMillis();
        if (Math.abs(timeMillis - ((Date)execution.get(0)).getTime()) > 1000L) {
            return (Date)execution.get(0);
        }
        return (Date)execution.get(1);
    }

    public static Date nextTime(String cron) {
        List execution = (List)CronUtils.getNextExecution(cron, 2, false);
        return (Date)execution.get(1);
    }
}

