/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.schedule.utils;

import com.taotao.cloud.job.schedule.model.entity.Task;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class JobInvokeUtil {
    public static void invokeMethod(Task task) throws Exception {
        String invokeTarget = task.getInvokeTarget();
        String beanName = JobInvokeUtil.getBeanName(invokeTarget);
        String methodName = JobInvokeUtil.getMethodName(invokeTarget);
        List<Object[]> methodParams = JobInvokeUtil.getMethodParams(invokeTarget);
        Object bean = Class.forName(beanName).newInstance();
        JobInvokeUtil.invokeMethod(bean, methodName, methodParams);
    }

    private static void invokeMethod(Object bean, String methodName, List<Object[]> methodParams) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (methodParams != null && methodParams.size() > 0) {
            Method method = bean.getClass().getDeclaredMethod(methodName, JobInvokeUtil.getMethodParamsType(methodParams));
            method.invoke(bean, JobInvokeUtil.getMethodParamsValue(methodParams));
        } else {
            Method method = bean.getClass().getDeclaredMethod(methodName, new Class[0]);
            method.invoke(bean, new Object[0]);
        }
    }

    public static String getBeanName(String invokeTarget) {
        String beanName = StringUtils.substringBefore((String)invokeTarget, (String)"(");
        return StringUtils.substringBeforeLast((String)beanName, (String)".");
    }

    public static String getMethodName(String invokeTarget) {
        String methodName = StringUtils.substringBefore((String)invokeTarget, (String)"(");
        return StringUtils.substringAfterLast((String)methodName, (String)".");
    }

    public static List<Object[]> getMethodParams(String invokeTarget) {
        String[] methodParams;
        LinkedList<Object[]> classs = new LinkedList<Object[]>();
        String methodStr = StringUtils.substringBetween((String)invokeTarget, (String)"(", (String)")");
        if (StringUtils.isEmpty((String)methodStr)) {
            return classs;
        }
        for (String methodParam : methodParams = methodStr.split(",")) {
            String str = StringUtils.trimToEmpty((String)methodParam);
            if (StringUtils.contains((String)str, (String)"'")) {
                classs.add(new Object[]{StringUtils.replace((String)str, (String)"'", (String)""), String.class});
                continue;
            }
            if (StringUtils.equals((String)str, (String)"true") || StringUtils.equalsIgnoreCase((String)str, (String)"false")) {
                classs.add(new Object[]{Boolean.valueOf(str), Boolean.class});
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)str, (String)"L")) {
                classs.add(new Object[]{Long.valueOf(StringUtils.replace((String)str, (String)"L", (String)"")), Long.class});
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)str, (String)"D")) {
                classs.add(new Object[]{Double.valueOf(StringUtils.replace((String)str, (String)"D", (String)"")), Double.class});
                continue;
            }
            classs.add(new Object[]{Integer.valueOf(str), Integer.class});
        }
        return classs;
    }

    public static Class<?>[] getMethodParamsType(List<Object[]> methodParams) {
        Class[] classs = new Class[methodParams.size()];
        int index = 0;
        for (Object[] os : methodParams) {
            classs[index] = (Class)os[1];
            ++index;
        }
        return classs;
    }

    public static Object[] getMethodParamsValue(List<Object[]> methodParams) {
        Object[] classs = new Object[methodParams.size()];
        int index = 0;
        for (Object[] os : methodParams) {
            classs[index] = os[0];
            ++index;
        }
        return classs;
    }
}

