/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.xxl.configuration;

import com.taotao.cloud.common.constant.CommonConstant;
import com.taotao.cloud.common.utils.common.PropertyUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.job.xxl.properties.XxlAdminProperties;
import com.taotao.cloud.job.xxl.properties.XxlExecutorProperties;
import com.taotao.cloud.job.xxl.properties.XxlJobProperties;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={XxlJobProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.job.xxl", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class XxlJobAutoConfiguration
implements InitializingBean {
    private static final String TAO_TAO_CLOUD_XXL_JOB_ADMIN = "taotao-cloud-xxljob";
    @Autowired
    private XxlJobProperties xxlJobProperties;
    @Autowired(required=false)
    private DiscoveryClient discoveryClient;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(XxlJobAutoConfiguration.class, (String)"taotao-cloud-starter-job-xxl", (String[])new String[0]);
    }

    @Bean
    public XxlJobSpringExecutor xxlJobSpringExecutor() {
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        XxlExecutorProperties executor = this.xxlJobProperties.getExecutor();
        String appName = executor.getAppname();
        if (!StringUtils.hasText((String)appName)) {
            appName = PropertyUtils.getProperty((String)CommonConstant.SPRING_APP_NAME_KEY);
        }
        xxlJobSpringExecutor.setAppname(appName);
        xxlJobSpringExecutor.setAddress(executor.getAddress());
        xxlJobSpringExecutor.setIp(executor.getIp());
        xxlJobSpringExecutor.setPort(executor.getPort().intValue());
        xxlJobSpringExecutor.setAccessToken(executor.getAccessToken());
        xxlJobSpringExecutor.setLogPath(executor.getLogPath());
        xxlJobSpringExecutor.setLogRetentionDays(executor.getLogRetentionDays().intValue());
        if (!StringUtils.hasText((String)this.xxlJobProperties.getAdmin().getAddresses())) {
            String serverList = this.discoveryClient.getServices().stream().filter(s -> s.contains(TAO_TAO_CLOUD_XXL_JOB_ADMIN)).flatMap(s -> this.discoveryClient.getInstances(s).stream()).map(instance -> String.format("http://%s:%s", instance.getHost(), instance.getPort())).collect(Collectors.joining(","));
            xxlJobSpringExecutor.setAdminAddresses(serverList);
            XxlAdminProperties admin = this.xxlJobProperties.getAdmin();
            admin.setAddresses(serverList);
            this.xxlJobProperties.setAdmin(admin);
        } else {
            xxlJobSpringExecutor.setAdminAddresses(this.xxlJobProperties.getAdmin().getAddresses());
        }
        return xxlJobSpringExecutor;
    }
}

