/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.xxl.executor.core;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.job.xxl.executor.annotation.XxlRegister;
import com.taotao.cloud.job.xxl.executor.model.XxlJobGroup;
import com.taotao.cloud.job.xxl.executor.model.XxlJobInfo;
import com.taotao.cloud.job.xxl.executor.service.JobGroupService;
import com.taotao.cloud.job.xxl.executor.service.JobInfoService;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;

@Component
public class XxlJobAutoRegister
implements ApplicationListener<ApplicationReadyEvent>,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    @Autowired
    private JobGroupService jobGroupService;
    @Autowired
    private JobInfoService jobInfoService;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
            this.addJobGroup();
        }
        catch (Exception e) {
            LogUtils.error((String)"get xxl-job cookie error!", (Object[])new Object[0]);
            return;
        }
        this.addJobInfo();
    }

    private void addJobGroup() {
        if (this.jobGroupService.preciselyCheck()) {
            return;
        }
        if (this.jobGroupService.autoRegisterGroup()) {
            LogUtils.info((String)"auto register xxl-job group success!", (Object[])new Object[0]);
        }
    }

    private void addJobInfo() {
        String[] beanDefinitionNames;
        List<XxlJobGroup> jobGroups = this.jobGroupService.getJobGroup();
        XxlJobGroup xxlJobGroup = jobGroups.get(0);
        for (String beanDefinitionName : beanDefinitionNames = this.applicationContext.getBeanNamesForType(Object.class, false, true)) {
            Object bean = this.applicationContext.getBean(beanDefinitionName);
            Map annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), method -> (XxlJob)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, XxlJob.class));
            for (Map.Entry methodXxlJobEntry : annotatedMethods.entrySet()) {
                Optional<XxlJobInfo> first;
                Method executeMethod = (Method)methodXxlJobEntry.getKey();
                XxlJob xxlJob = (XxlJob)methodXxlJobEntry.getValue();
                if (!executeMethod.isAnnotationPresent(XxlRegister.class)) continue;
                XxlRegister xxlRegister = executeMethod.getAnnotation(XxlRegister.class);
                List<XxlJobInfo> jobInfo = this.jobInfoService.getJobInfo(xxlJobGroup.getId(), xxlJob.value());
                if (!jobInfo.isEmpty() && (first = jobInfo.stream().filter(xxlJobInfo -> xxlJobInfo.getExecutorHandler().equals(xxlJob.value())).findFirst()).isPresent()) continue;
                XxlJobInfo xxlJobInfo2 = this.createXxlJobInfo(xxlJobGroup, xxlJob, xxlRegister);
                Integer jobInfoId = this.jobInfoService.addJobInfo(xxlJobInfo2);
                LogUtils.info((String)"xxljob \u81ea\u52a8\u6ce8\u518c\u6210\u529f XxlJobInfo: {}, jobInfoId: {}", (Object[])new Object[]{xxlJobInfo2, jobInfoId});
            }
        }
    }

    private XxlJobInfo createXxlJobInfo(XxlJobGroup xxlJobGroup, XxlJob xxlJob, XxlRegister xxlRegister) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setJobGroup(xxlJobGroup.getId());
        xxlJobInfo.setJobDesc(xxlRegister.jobDesc());
        xxlJobInfo.setAuthor(xxlRegister.author());
        xxlJobInfo.setScheduleType("CRON");
        xxlJobInfo.setScheduleConf(xxlRegister.cron());
        xxlJobInfo.setGlueType("BEAN");
        xxlJobInfo.setExecutorHandler(xxlJob.value());
        xxlJobInfo.setExecutorRouteStrategy(xxlRegister.executorRouteStrategy());
        xxlJobInfo.setMisfireStrategy("DO_NOTHING");
        xxlJobInfo.setExecutorBlockStrategy("SERIAL_EXECUTION");
        xxlJobInfo.setExecutorTimeout(0);
        xxlJobInfo.setExecutorFailRetryCount(0);
        xxlJobInfo.setGlueRemark("GLUE\u4ee3\u7801\u521d\u59cb\u5316");
        xxlJobInfo.setTriggerStatus(xxlRegister.triggerStatus());
        return xxlJobInfo;
    }
}

