/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.xxl.executor.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.taotao.cloud.job.xxl.executor.model.XxlJobGroup;
import com.taotao.cloud.job.xxl.executor.service.JobGroupService;
import com.taotao.cloud.job.xxl.executor.service.JobLoginService;
import com.taotao.cloud.job.xxl.properties.XxlJobProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobGroupServiceImpl
implements JobGroupService {
    @Autowired
    private XxlJobProperties xxlJobProperties;
    @Autowired
    private JobLoginService jobLoginService;

    @Override
    public List<XxlJobGroup> getJobGroup() {
        String url = this.xxlJobProperties.getAdmin().getAddresses() + "/jobgroup/pageList";
        HttpResponse response = HttpRequest.post((String)url).form("appname", (Object)this.xxlJobProperties.getExecutor().getAppname()).form("title", (Object)this.xxlJobProperties.getExecutor().getTitle()).cookie(this.jobLoginService.getCookie()).execute();
        String body = response.body();
        JSONArray array = (JSONArray)JSONUtil.parse((Object)body).getByPath("data", JSONArray.class);
        return array.stream().map(o -> (XxlJobGroup)JSONUtil.toBean((JSONObject)((JSONObject)o), XxlJobGroup.class)).collect(Collectors.toList());
    }

    @Override
    public boolean autoRegisterGroup() {
        String url = this.xxlJobProperties.getAdmin().getAddresses() + "/jobgroup/save";
        HttpResponse response = HttpRequest.post((String)url).form("appname", (Object)this.xxlJobProperties.getExecutor().getAppname()).form("title", (Object)this.xxlJobProperties.getExecutor().getTitle()).cookie(this.jobLoginService.getCookie()).execute();
        Object code = JSONUtil.parse((Object)response.body()).getByPath("code");
        return code.equals(200);
    }

    @Override
    public boolean preciselyCheck() {
        List<XxlJobGroup> jobGroup = this.getJobGroup();
        Optional<XxlJobGroup> has = jobGroup.stream().filter(xxlJobGroup -> xxlJobGroup.getAppname().equals(this.xxlJobProperties.getExecutor().getAppname()) && xxlJobGroup.getTitle().equals(this.xxlJobProperties.getExecutor().getTitle())).findAny();
        return has.isPresent();
    }
}

