/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.xxl.executor.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.taotao.cloud.job.xxl.executor.model.XxlJobInfo;
import com.taotao.cloud.job.xxl.executor.service.JobInfoService;
import com.taotao.cloud.job.xxl.executor.service.JobLoginService;
import com.taotao.cloud.job.xxl.properties.XxlJobProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobInfoServiceImpl
implements JobInfoService {
    @Autowired
    private XxlJobProperties xxlJobProperties;
    @Autowired
    private JobLoginService jobLoginService;

    @Override
    public List<XxlJobInfo> getJobInfo(Integer jobGroupId, String executorHandler) {
        String url = this.xxlJobProperties.getAdmin().getAddresses() + "/jobinfo/pageList";
        HttpResponse response = HttpRequest.post((String)url).form("jobGroup", (Object)jobGroupId).form("executorHandler", (Object)executorHandler).form("triggerStatus", (Object)-1).cookie(this.jobLoginService.getCookie()).execute();
        String body = response.body();
        JSONArray array = (JSONArray)JSONUtil.parse((Object)body).getByPath("data", JSONArray.class);
        return array.stream().map(o -> (XxlJobInfo)JSONUtil.toBean((JSONObject)((JSONObject)o), XxlJobInfo.class)).collect(Collectors.toList());
    }

    @Override
    public Integer addJobInfo(XxlJobInfo xxlJobInfo) {
        String url = this.xxlJobProperties.getAdmin().getAddresses() + "/jobinfo/add";
        Map paramMap = BeanUtil.beanToMap((Object)xxlJobInfo, (String[])new String[0]);
        HttpResponse response = HttpRequest.post((String)url).form(paramMap).cookie(this.jobLoginService.getCookie()).execute();
        JSON json = JSONUtil.parse((Object)response.body());
        Object code = json.getByPath("code");
        if (code.equals(200)) {
            return Convert.toInt((Object)json.getByPath("content"));
        }
        throw new RuntimeException("add jobInfo error!");
    }
}

