/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.job.xxl.executor.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.job.xxl.executor.service.JobLoginService;
import com.taotao.cloud.job.xxl.properties.XxlJobProperties;
import java.net.HttpCookie;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobLoginServiceImpl
implements JobLoginService {
    @Autowired
    private XxlJobProperties xxlJobProperties;
    private final Map<String, String> loginCookie = new HashMap<String, String>();

    @Override
    public void login() {
        if (StrUtil.isBlank((CharSequence)this.xxlJobProperties.getAdmin().getAddresses())) {
            throw new RuntimeException("xxl admin address url \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = this.xxlJobProperties.getAdmin().getAddresses() + "/login";
        HttpResponse response = HttpRequest.post((String)url).form("userName", (Object)this.xxlJobProperties.getAdmin().getUsername()).form("password", (Object)this.xxlJobProperties.getAdmin().getPassword()).execute();
        List cookies = response.getCookies();
        Optional<HttpCookie> cookieOpt = cookies.stream().filter(cookie -> "XXL_JOB_LOGIN_IDENTITY".equals(cookie.getName())).findFirst();
        if (cookieOpt.isEmpty()) {
            LogUtils.info((String)"get xxl-job cookie error!", (Object[])new Object[0]);
            throw new RuntimeException("get xxl-job cookie error!");
        }
        String value = cookieOpt.get().getValue();
        this.loginCookie.put("XXL_JOB_LOGIN_IDENTITY", value);
    }

    @Override
    public String getCookie() {
        for (int i = 0; i < 3; ++i) {
            String cookieStr = this.loginCookie.get("XXL_JOB_LOGIN_IDENTITY");
            if (cookieStr != null) {
                return "XXL_JOB_LOGIN_IDENTITY=" + cookieStr;
            }
            try {
                this.login();
                continue;
            }
            catch (Exception e) {
                LogUtils.error((String)"\u83b7\u53d6xxljob cookieStr \u9519\u8bef, \u6b21\u6570: {}", (Object[])new Object[]{i});
            }
        }
        throw new RuntimeException("get xxl-job cookie error!");
    }
}

