/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.laytpl.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.laytpl.model.FmtFunc;
import com.taotao.cloud.laytpl.model.LayTplTemplate;
import com.taotao.cloud.laytpl.properties.LayTplProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={LayTplProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.laytpl", name={"enabled"}, havingValue="true")
public class LayTplAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(LayTplAutoConfiguration.class, (String)"taotao-cloud-starter-laytpl", (String[])new String[0]);
    }

    @Bean(value={"fmt"})
    public FmtFunc fmtFunc(LayTplProperties properties) {
        return new FmtFunc(properties);
    }

    @Bean(value={"layTpl"})
    public LayTplTemplate layTplTemplate(FmtFunc fmtFunc, LayTplProperties properties) {
        return new LayTplTemplate(properties, fmtFunc);
    }
}

