/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.limit.configuration;

import com.google.common.util.concurrent.RateLimiter;
import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.limit.ext.LimitAspect;
import com.taotao.cloud.limit.ext.LimitProperties;
import com.taotao.cloud.limit.guava.GuavaLimitAspect;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={LimitProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.limit", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LimitAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(LimitAutoConfiguration.class, (String)"taotao-cloud-starter-limit", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnBean(value={RedisRepository.class})
    public LimitAspect limitAspect(RedisRepository redisRepository) {
        return new LimitAspect(redisRepository);
    }

    @Bean
    @ConditionalOnClass(value={RateLimiter.class})
    public GuavaLimitAspect guavaLimitAspect() {
        return new GuavaLimitAspect();
    }
}

