/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.limit.ext;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.ImmutableList;
import com.taotao.cloud.cache.redis.repository.RedisRepository;
import com.taotao.cloud.common.enums.ResultEnum;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.common.utils.servlet.RequestUtils;
import com.taotao.cloud.limit.annotation.Limit;
import com.taotao.cloud.limit.ext.LimitException;
import com.taotao.cloud.limit.ext.LimitType;
import java.lang.reflect.Method;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

@Aspect
public class LimitAspect {
    private static final String UNKNOWN = "unknown";
    private final RedisRepository redisRepository;

    public LimitAspect(RedisRepository redisRepository) {
        this.redisRepository = redisRepository;
    }

    @Around(value="@annotation(limit)")
    public Object around(ProceedingJoinPoint pjp, Limit limit) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        LimitType limitType = limit.limitType();
        String name = limit.name();
        int limitPeriod = limit.period();
        int limitCount = limit.count();
        String key = switch (limitType) {
            default -> throw new IncompatibleClassChangeError();
            case LimitType.IP -> RequestUtils.getHttpServletRequestIpAddress();
            case LimitType.CUSTOMER -> StrUtil.isBlank((CharSequence)limit.key()) ? org.apache.commons.lang.StringUtils.upperCase((String)method.getName()) : limit.key();
        };
        ImmutableList keys = ImmutableList.of((Object)StringUtils.join((String)limit.prefix(), (Object[])new Object[]{key}));
        try {
            String luaScript = this.buildLuaScript();
            DefaultRedisScript redisScript = new DefaultRedisScript(luaScript, Number.class);
            Number count = (Number)this.redisRepository.getRedisTemplate().execute((RedisScript)redisScript, (List)keys, new Object[]{limitCount, limitPeriod});
            if (count != null && count.intValue() <= limitCount) {
                return pjp.proceed();
            }
            throw new LimitException(ResultEnum.BLACKLIST);
        }
        catch (Throwable e) {
            LogUtils.error((Throwable)e);
            throw new LimitException(ResultEnum.ERROR);
        }
    }

    public String buildLuaScript() {
        return "local c\nc = redis.call('get',KEYS[1])\n\n-- \u8c03\u7528\u4e0d\u8d85\u8fc7\u6700\u5927\u503c\uff0c\u5219\u76f4\u63a5\u8fd4\u56de\nif c and tonumber(c) > tonumber(ARGV[1]) then\n\treturn c;\nend\n\n-- \u6267\u884c\u8ba1\u7b97\u5668\u81ea\u52a0\nc = redis.call('incr',KEYS[1])\nif tonumber(c) == 1 then\n-- \u4ece\u7b2c\u4e00\u6b21\u8c03\u7528\u5f00\u59cb\u9650\u6d41\uff0c\u8bbe\u7f6e\u5bf9\u5e94\u952e\u503c\u7684\u8fc7\u671f\n\tredis.call('expire',KEYS[1],ARGV[2])\nend\n\nreturn c;\n";
    }
}

