/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.limit.ratelimiter;

import com.taotao.cloud.limit.ext.LimitProperties;
import com.taotao.cloud.limit.ratelimiter.BizKeyProvider;
import com.taotao.cloud.limit.ratelimiter.RateLimitAspectHandler;
import com.taotao.cloud.limit.ratelimiter.RateLimiterService;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={LimitProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.limit", name={"enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfiguration(after={RedisAutoConfiguration.class})
public class RateLimiterAutoConfiguration {
    @Bean
    public BizKeyProvider bizKeyProvider() {
        return new BizKeyProvider();
    }

    @Bean
    public RateLimiterService rateLimiterService(BizKeyProvider bizKeyProvider) {
        return new RateLimiterService(bizKeyProvider);
    }

    @Bean
    public RateLimitAspectHandler rateLimitAspectHandler(RedissonClient client, RateLimiterService rateLimiterService) {
        return new RateLimitAspectHandler(client, rateLimiterService);
    }
}

