/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.metrics.configuration;

import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.metrics.druid.DruidDataSourcePoolMetadata;
import com.taotao.cloud.metrics.druid.DruidMetrics;
import com.taotao.cloud.metrics.properties.DruidMetricsProperties;
import com.taotao.cloud.metrics.properties.MetricsProperties;
import com.taotao.cloud.metrics.properties.SentinelMetricsProperties;
import com.taotao.cloud.metrics.properties.UndertowMetricsProperties;
import com.taotao.cloud.metrics.undertow.UndertowMetrics;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={MetricsProperties.class, DruidMetricsProperties.class, SentinelMetricsProperties.class, UndertowMetricsProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.metrics", name={"enabled"}, havingValue="true")
public class MetricsAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MetricsAutoConfiguration.class, (String)"taotao-cloud-starter-metrics", (String[])new String[0]);
    }

    @Configuration
    @ConditionalOnProperty(prefix="taotao.cloud.metrics.sentinel", name={"enabled"}, havingValue="true")
    public static class SentinelMetricsConfiguration {
    }

    @Configuration
    @AutoConfigureBefore(value={ServletWebServerFactoryAutoConfiguration.class})
    @ConditionalOnClass(value={Undertow.class})
    @ConditionalOnProperty(prefix="taotao.cloud.metrics.undertow", name={"enabled"}, havingValue="true")
    public static class UndertowMetricsConfiguration {
        @Bean
        public UndertowMetrics undertowMetrics() {
            return new UndertowMetrics();
        }

        @Bean
        public UndertowBuilderCustomizer undertowBuilderCustomizerEnableStatistics() {
            return builder -> builder.setServerOption(UndertowOptions.ENABLE_STATISTICS, (Object)true);
        }
    }

    @Configuration
    @ConditionalOnClass(value={DruidDataSource.class})
    @ConditionalOnProperty(prefix="taotao.cloud.metrics.druid", name={"enabled"}, havingValue="true")
    public static class DruidMetricsConfiguration {
        private static final String DATASOURCE_SUFFIX = "dataSource";

        @Bean
        public DataSourcePoolMetadataProvider druidDataSourceMetadataProvider() {
            return dataSource -> {
                DruidDataSource druidDataSource = (DruidDataSource)DataSourceUnwrapper.unwrap((DataSource)dataSource, DruidDataSource.class);
                if (druidDataSource != null) {
                    return new DruidDataSourcePoolMetadata(druidDataSource);
                }
                return null;
            };
        }

        @Bean
        @ConditionalOnMissingBean
        public StatFilter statFilter() {
            return new StatFilter();
        }

        @Bean
        public DruidMetrics druidMetrics(ObjectProvider<Map<String, DataSource>> dataSourcesProvider) {
            Map dataSourceMap = (Map)dataSourcesProvider.getIfAvailable(HashMap::new);
            HashMap<String, DruidDataSource> druidDataSourceMap = new HashMap<String, DruidDataSource>(2);
            dataSourceMap.forEach((name, dataSource) -> druidDataSourceMap.put(DruidMetricsConfiguration.getDataSourceName(name), (DruidDataSource)DataSourceUnwrapper.unwrap((DataSource)dataSource, DruidDataSource.class)));
            return new DruidMetrics(druidDataSourceMap);
        }

        private static String getDataSourceName(String beanName) {
            if (beanName.length() > DATASOURCE_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)DATASOURCE_SUFFIX)) {
                return beanName.substring(0, beanName.length() - DATASOURCE_SUFFIX.length());
            }
            return beanName;
        }
    }
}

